/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.snippets.SnippetRuntime;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.IdentityHashCodeSnippets;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

final class SubstrateIdentityHashCodeSnippets
extends IdentityHashCodeSnippets {
    static final SnippetRuntime.SubstrateForeignCallDescriptor GENERATE_IDENTITY_HASH_CODE = SnippetRuntime.findForeignCall(IdentityHashCodeSupport.class, "generateIdentityHashCode", true, IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
    static final SnippetRuntime.SubstrateForeignCallDescriptor COMPUTE_ABSENT_IDENTITY_HASH_CODE = SnippetRuntime.findForeignCall(IdentityHashCodeSupport.class, "computeAbsentIdentityHashCode", true, new LocationIdentity[0]);

    SubstrateIdentityHashCodeSnippets() {
    }

    static IdentityHashCodeSnippets.Templates createTemplates(OptionValues options, Providers providers) {
        return new IdentityHashCodeSnippets.Templates((IdentityHashCodeSnippets)new SubstrateIdentityHashCodeSnippets(), options, providers, IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
    }

    protected int computeIdentityHashCode(Object obj) {
        int identityHashCode;
        Word header;
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        if (ol.hasFixedIdentityHashField()) {
            int offset = ol.getFixedIdentityHashOffset();
            int identityHashCode2 = ObjectAccess.readInt((Object)obj, (int)offset, (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (identityHashCode2 == 0 ? 1 : 0) != 0)) {
                identityHashCode2 = SubstrateIdentityHashCodeSnippets.foreignCall(GENERATE_IDENTITY_HASH_CODE, obj);
            }
            return identityHashCode2;
        }
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        if (BranchProbabilityNode.probability((double)0.6, (boolean)oh.hasOptionalIdentityHashField(header = ObjectHeader.readHeaderFromObject(obj)))) {
            int offset = LayoutEncoding.getOptionalIdentityHashOffset(obj);
            identityHashCode = ObjectAccess.readInt((Object)obj, (int)offset, (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
        } else {
            identityHashCode = SubstrateIdentityHashCodeSnippets.foreignCall(COMPUTE_ABSENT_IDENTITY_HASH_CODE, obj);
        }
        return identityHashCode;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int foreignCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);
}

