/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.lir.DeoptEntryOp;
import com.oracle.svm.core.graal.nodes.DeoptEntrySupport;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.NodeWithState;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Anchor}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class DeoptEntryNode
extends WithExceptionNode
implements DeoptEntrySupport,
DeoptimizingNode.DeoptAfter,
SingleMemoryKill,
ControlFlowAnchored {
    public static final NodeClass<DeoptEntryNode> TYPE = NodeClass.create(DeoptEntryNode.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    private final int proxifiedInvokeBci;

    protected DeoptEntryNode(int proxifiedInvokeBci) {
        super(TYPE, StampFactory.forVoid());
        this.proxifiedInvokeBci = proxifiedInvokeBci;
    }

    public static DeoptEntryNode create(int proxifiedInvokeBci) {
        assert (proxifiedInvokeBci != -5);
        return new DeoptEntryNode(proxifiedInvokeBci);
    }

    public static DeoptEntryNode create() {
        return new DeoptEntryNode(-5);
    }

    public void generate(NodeLIRBuilderTool gen) {
        AbstractBeginNode exceptionNode = this.exceptionEdge();
        LabelRef exceptionRef = exceptionNode instanceof UnreachableBeginNode ? null : ((NodeLIRBuilder)gen).getLIRBlock((FixedNode)exceptionNode);
        gen.getLIRGeneratorTool().append((LIRInstruction)new DeoptEntryOp(((NodeLIRBuilder)gen).stateForWithExceptionEdge((NodeWithState)this, this.stateAfter(), exceptionRef)));
        gen.getLIRGeneratorTool().emitJump(((NodeLIRBuilder)gen).getLIRBlock((FixedNode)this.next()));
    }

    public boolean canDeoptimize() {
        return true;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public FrameState stateAfter() {
        return this.stateAfter;
    }

    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages((Node)this.stateAfter, (Node)x);
        this.stateAfter = x;
    }

    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public int getProxifiedInvokeBci() {
        return this.proxifiedInvokeBci;
    }
}

