/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import jdk.vm.ci.code.CallingConvention;

public final class SubstrateCallingConventionType
implements CallingConvention.Type {
    public final SubstrateCallingConventionKind kind;
    public final boolean outgoing;
    public final AssignedLocation[] fixedParameterAssignment;
    public final AssignedLocation[] returnSaving;
    static final EnumMap<SubstrateCallingConventionKind, SubstrateCallingConventionType> outgoingTypes = new EnumMap(SubstrateCallingConventionKind.class);
    static final EnumMap<SubstrateCallingConventionKind, SubstrateCallingConventionType> incomingTypes = new EnumMap(SubstrateCallingConventionKind.class);

    private SubstrateCallingConventionType(SubstrateCallingConventionKind kind, boolean outgoing, AssignedLocation[] fixedRegisters, AssignedLocation[] returnSaving) {
        this.kind = kind;
        this.outgoing = outgoing;
        this.fixedParameterAssignment = fixedRegisters;
        this.returnSaving = returnSaving;
    }

    public static SubstrateCallingConventionType makeCustom(boolean outgoing, AssignedLocation[] parameters, AssignedLocation[] returns) {
        return new SubstrateCallingConventionType(SubstrateCallingConventionKind.Custom, outgoing, Objects.requireNonNull(parameters), Objects.requireNonNull(returns));
    }

    public boolean nativeABI() {
        return this.kind.isNativeABI();
    }

    public boolean customABI() {
        return this.kind.isCustom();
    }

    public boolean usesReturnBuffer() {
        return this.outgoing && this.returnSaving != null && this.returnSaving.length >= 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubstrateCallingConventionType that = (SubstrateCallingConventionType)o;
        return this.outgoing == that.outgoing && this.kind == that.kind && Arrays.equals(this.fixedParameterAssignment, that.fixedParameterAssignment) && Arrays.equals(this.returnSaving, that.returnSaving);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.outgoing, Arrays.hashCode(this.fixedParameterAssignment), Arrays.hashCode(this.returnSaving)});
    }

    static {
        for (SubstrateCallingConventionKind kind : SubstrateCallingConventionKind.values()) {
            if (kind.isCustom()) continue;
            outgoingTypes.put(kind, new SubstrateCallingConventionType(kind, true, null, null));
            incomingTypes.put(kind, new SubstrateCallingConventionType(kind, false, null, null));
        }
    }
}

