/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class ThreadStackPrinter {
    private static final int MAX_STACK_FRAMES_PER_THREAD_TO_PRINT = 100000;

    @NeverInline(value="debugger breakpoint")
    @Uninterruptible(reason="Called from uninterruptible code.")
    public static void printBacktrace() {
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean printStacktrace(Pointer startSP, CodePointer startIP, Stage0StackFramePrintVisitor printVisitor, Log log) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        JavaStackWalker.initWalk(walk, startSP, startIP);
        JavaFrameAnchor anchor = walk.getAnchor();
        if (walk.getIPCodeInfo().isNull() && anchor.isNonNull()) {
            ThreadStackPrinter.logFrameAnchor(log, startSP, startIP);
            walk.setSP(anchor.getLastJavaSP());
            walk.setPossiblyStaleIP(anchor.getLastJavaIP());
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(anchor.getLastJavaIP()));
        }
        return JavaStackWalker.doWalk(walk, printVisitor, log);
    }

    @Uninterruptible(reason="CodeInfo in JavaStackWalk is currently null, so printing to log is safe right now.", calleeMustBe=false)
    private static void logFrameAnchor(Log log, Pointer startSP, CodePointer startIP) {
        Stage0StackFramePrintVisitor.logFrameRaw(log, startSP, startIP, (CodeInfo)WordFactory.nullPointer());
        log.string("  IP is not within Java code. Trying frame anchor of last Java frame instead.").newline();
    }

    public static class Stage0StackFramePrintVisitor
    extends ParameterizedStackFrameVisitor {
        protected int printedFrames;

        public Stage0StackFramePrintVisitor reset() {
            this.printedFrames = 0;
            return this;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
        protected final boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame, Object data) {
            Log log = (Log)data;
            if (this.printedFrames >= 100000) {
                log.string("... (truncated)").newline();
                return false;
            }
            this.logFrame(log, sp, ip, codeInfo, deoptFrame);
            log.newline();
            return true;
        }

        @Override
        protected final boolean unknownFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, Object data) {
            Log log = (Log)data;
            Stage0StackFramePrintVisitor.logFrameRaw(log, sp, ip, (CodeInfo)WordFactory.nullPointer());
            if (DeoptimizationSupport.enabled()) {
                log.string("  deoptFrame=").object(deoptimizedFrame);
            }
            log.string("  IP is not within Java code. Aborting stack trace printing.").newline();
            ++this.printedFrames;
            return false;
        }

        protected void logFrame(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
            Stage0StackFramePrintVisitor.logFrameRaw(log, sp, ip, codeInfo);
            ++this.printedFrames;
        }

        protected static void logFrameRaw(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo) {
            log.string("SP ").zhex((WordBase)sp);
            log.string(" IP ").zhex((WordBase)ip);
            if (codeInfo.isNonNull()) {
                long frameSize = CodeInfoAccess.lookupTotalFrameSize(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip));
                log.string(" size=").signed(frameSize, 4, 1);
            }
        }
    }

    public static class Stage1StackFramePrintVisitor
    extends Stage0StackFramePrintVisitor {
        @Override
        protected void logFrame(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
            if (deoptFrame != null) {
                this.logVirtualFrames(log, sp, ip, codeInfo, deoptFrame);
            } else {
                this.logStackFrame(log, sp, ip, codeInfo);
            }
        }

        protected void logVirtualFrames(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
            for (DeoptimizedFrame.VirtualFrame frame = deoptFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
                if (this.printedFrames >= 100000) {
                    log.string("... (truncated)").newline();
                    break;
                }
                boolean compilationRoot = frame.getCaller() == null;
                Stage1StackFramePrintVisitor.printFrameIdentifier(log, (CodeInfo)WordFactory.nullPointer(), deoptFrame, compilationRoot);
                Stage1StackFramePrintVisitor.logFrameRaw(log, sp, ip, codeInfo);
                Stage1StackFramePrintVisitor.logFrameInfo(log, frame.getFrameInfo(), "image code, deopt");
                if (!compilationRoot) {
                    log.newline();
                }
                ++this.printedFrames;
            }
        }

        private void logStackFrame(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo) {
            Stage1StackFramePrintVisitor.printFrameIdentifier(log, codeInfo, null, true);
            Stage1StackFramePrintVisitor.logFrameRaw(log, sp, ip, codeInfo);
            log.spaces(2);
            if (DeoptimizationSupport.enabled()) {
                log.string("[").string(CodeInfoAccess.getName(codeInfo)).string("] ");
            }
            ++this.printedFrames;
        }

        protected static void logFrameInfo(Log log, FrameInfoQueryResult frameInfo, String runtimeMethodInfoName) {
            log.string("  ");
            if (runtimeMethodInfoName != null) {
                log.string("[").string(runtimeMethodInfoName).string("] ");
            }
            frameInfo.log(log);
        }

        protected static void printFrameIdentifier(Log log, CodeInfo codeInfo, DeoptimizedFrame deoptFrame, boolean isCompilationRoot) {
            char ch = Stage1StackFramePrintVisitor.getFrameIdentifier(codeInfo, deoptFrame, isCompilationRoot);
            log.character(ch).spaces(2);
        }

        private static char getFrameIdentifier(CodeInfo codeInfo, DeoptimizedFrame deoptFrame, boolean isCompilationRoot) {
            if (deoptFrame != null) {
                return 'D';
            }
            if (!isCompilationRoot) {
                return 'i';
            }
            if (codeInfo == CodeInfoTable.getImageCodeInfo()) {
                return 'A';
            }
            return 'J';
        }
    }

    public static class StackFramePrintVisitor
    extends Stage1StackFramePrintVisitor {
        private final CodeInfoDecoder.FrameInfoCursor frameInfoCursor = new CodeInfoDecoder.FrameInfoCursor();

        @Override
        protected void logFrame(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
            if (deoptFrame != null) {
                this.logVirtualFrames(log, sp, ip, codeInfo, deoptFrame);
                return;
            }
            boolean isFirst = true;
            this.frameInfoCursor.initialize(codeInfo, ip, false);
            while (this.frameInfoCursor.advance()) {
                if (this.printedFrames >= 100000) {
                    log.string("... (truncated)").newline();
                    break;
                }
                if (!isFirst) {
                    log.newline();
                }
                boolean compilationRoot = !this.frameInfoCursor.hasCaller();
                StackFramePrintVisitor.printFrameIdentifier(log, codeInfo, null, compilationRoot);
                StackFramePrintVisitor.logFrameRaw(log, sp, ip, codeInfo);
                String codeInfoName = DeoptimizationSupport.enabled() ? CodeInfoAccess.getName(codeInfo) : null;
                StackFramePrintVisitor.logFrameInfo(log, this.frameInfoCursor.get(), codeInfoName);
                isFirst = false;
                ++this.printedFrames;
            }
            if (isFirst) {
                super.logFrame(log, sp, ip, codeInfo, null);
                log.string("missing metadata");
            }
        }
    }
}

