/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ConcurrentHashMap;

@TargetClass(value=MethodHandles.class, innerClass={"Lookup"})
final class Target_java_lang_invoke_MethodHandles_Lookup {
    @Delete
    static ConcurrentHashMap<Target_java_lang_invoke_MemberName, MethodHandle> LOOKASIDE_TABLE;
    @Alias
    @RecomputeFieldValue(isFinal=true, kind=RecomputeFieldValue.Kind.None)
    private Class<?> lookupClass;
    @Alias
    @RecomputeFieldValue(isFinal=true, kind=RecomputeFieldValue.Kind.None)
    private Class<?> prevLookupClass;
    @Alias
    @RecomputeFieldValue(isFinal=true, kind=RecomputeFieldValue.Kind.None)
    private int allowedModes;

    Target_java_lang_invoke_MethodHandles_Lookup() {
    }

    @Substitute
    public Class<?> defineClass(byte[] bytes) {
        throw VMError.unimplemented("Defining new classes at runtime is not supported");
    }

    @Substitute
    private MethodHandle maybeBindCaller(Target_java_lang_invoke_MemberName method, MethodHandle mh, Target_java_lang_invoke_MethodHandles_Lookup boundCaller) throws IllegalAccessException {
        return mh;
    }

    @Substitute
    private IllegalAccessException makeAccessException(Class<?> targetClass) {
        String message = "access violation: " + targetClass;
        if (this == SubstrateUtil.cast(MethodHandles.publicLookup(), Target_java_lang_invoke_MethodHandles_Lookup.class)) {
            message = message + ", from public Lookup";
        } else {
            Module m = SubstrateUtil.cast(this.lookupClass, DynamicHub.class).getModule();
            message = message + ", from " + this.lookupClass + " (" + m + ")";
            if (this.prevLookupClass != null) {
                message = message + ", previous lookup " + this.prevLookupClass.getName() + " (" + SubstrateUtil.cast(this.prevLookupClass, DynamicHub.class).getModule() + ")";
            }
        }
        return new IllegalAccessException(message);
    }

    @Substitute
    void checkSecurityManager(Class<?> refc) {
    }
}

