/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;

public class JavaMonitorWaitEvent {
    public static void emit(long startTicks, Object obj, long notifier, long timeout, boolean timedOut) {
        if (HasJfrSupport.get()) {
            JavaMonitorWaitEvent.emit0(startTicks, obj, notifier, timeout, timedOut);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emit0(long startTicks, Object obj, long notifier, long timeout, boolean timedOut) {
        long duration = JfrTicks.duration(startTicks);
        if (JfrEvent.JavaMonitorWait.shouldEmit(duration)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.JavaMonitorWait);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, duration);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getStackTraceId(JfrEvent.JavaMonitorWait, 0));
            JfrNativeEventWriter.putClass(data, obj.getClass());
            JfrNativeEventWriter.putLong(data, notifier);
            JfrNativeEventWriter.putLong(data, timeout);
            JfrNativeEventWriter.putBoolean(data, timedOut);
            JfrNativeEventWriter.putLong(data, Word.objectToUntrackedPointer((Object)obj).rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

