/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

@AutomaticallyRegisteredImageSingleton(value={UniqueShortNameProvider.class}, onlyWith={UseDefault.class})
public class UniqueShortNameProviderDefaultImpl
implements UniqueShortNameProvider {
    @Override
    public String uniqueShortName(ClassLoader loader, ResolvedJavaType declaringClass, String methodName, Signature methodSignature, boolean isConstructor) {
        return SubstrateUtil.uniqueShortName(SubstrateUtil.classLoaderNameAndId(loader), declaringClass, methodName, methodSignature, isConstructor);
    }

    @Override
    public String uniqueShortName(Member m) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(m.getDeclaringClass().getName()).append(".");
        if (m instanceof Constructor) {
            fullName.append("<init>");
        } else {
            fullName.append(m.getName());
        }
        if (m instanceof Executable) {
            fullName.append("(");
            for (Class<?> c : ((Executable)m).getParameterTypes()) {
                fullName.append(c.getName()).append(",");
            }
            fullName.append(')');
            if (m instanceof Method) {
                fullName.append(((Method)m).getReturnType().getName());
            }
        }
        return SubstrateUtil.stripPackage(m.getDeclaringClass().getTypeName()) + "_" + (m instanceof Constructor ? "constructor" : m.getName()) + "_" + SubstrateUtil.digest(fullName.toString());
    }

    @Override
    public String uniqueShortLoaderName(ClassLoader classLoader) {
        return SubstrateUtil.classLoaderNameAndId(classLoader);
    }

    public static class UseDefault
    implements BooleanSupplier {
        public static boolean useDefaultProvider() {
            return !OS.LINUX.isCurrent() || !SubstrateOptions.useDebugInfoGeneration();
        }

        @Override
        public boolean getAsBoolean() {
            return UseDefault.useDefaultProvider();
        }
    }
}

