/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.Containers;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.RuntimeCodeInfoHistory;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.util.CounterSupport;
import com.oracle.svm.core.util.ImageHeapList;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.nodes.PauseNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class SubstrateDiagnostics {
    private static final int MAX_THREADS_TO_PRINT = 100000;
    private static final int MAX_FRAME_ANCHORS_TO_PRINT_PER_THREAD = 1000;
    private static final FastThreadLocalBytes<CCharPointer> threadOnlyAttachedForCrashHandler = FastThreadLocalFactory.createBytes(() -> 1, "SubstrateDiagnostics.threadOnlyAttachedForCrashHandler");
    private static final ImageCodeLocationInfoPrinter imageCodeLocationInfoPrinter = new ImageCodeLocationInfoPrinter();
    private static final ThreadStackPrinter.Stage0StackFramePrintVisitor[] printVisitors = new ThreadStackPrinter.Stage0StackFramePrintVisitor[]{new ThreadStackPrinter.StackFramePrintVisitor(), new ThreadStackPrinter.Stage1StackFramePrintVisitor(), new ThreadStackPrinter.Stage0StackFramePrintVisitor()};

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setOnlyAttachedForCrashHandler(IsolateThread thread) {
        threadOnlyAttachedForCrashHandler.getAddress(thread).write((byte)1);
    }

    public static boolean isThreadOnlyAttachedForCrashHandler(IsolateThread thread) {
        return threadOnlyAttachedForCrashHandler.getAddress(thread).read() != 0;
    }

    @Fold
    static FatalErrorState fatalErrorState() {
        return (FatalErrorState)ImageSingletons.lookup(FatalErrorState.class);
    }

    public static boolean isFatalErrorHandlingInProgress() {
        return SubstrateDiagnostics.fatalErrorState().diagnosticThread.get().isNonNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isFatalErrorHandlingThread() {
        return SubstrateDiagnostics.fatalErrorState().diagnosticThread.get() == CurrentIsolate.getCurrentThread();
    }

    public static int maxInvocations() {
        int result = 0;
        DiagnosticThunkRegistry thunks = DiagnosticThunkRegistry.singleton();
        for (int i = 0; i < thunks.size(); ++i) {
            result += thunks.getThunk(i).maxInvocationCount();
        }
        return result;
    }

    public static void printLocationInfo(Log log, UnsignedWord value, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        if (!(!value.notEqual(0) || imageCodeLocationInfoPrinter.printLocationInfo(log, value) || RuntimeCodeInfoMemory.singleton().printLocationInfo(log, value, allowJavaHeapAccess, allowUnsafeOperations) || VMThreads.printLocationInfo(log, value, allowUnsafeOperations) || Heap.getHeap().printLocationInfo(log, value, allowJavaHeapAccess, allowUnsafeOperations))) {
            log.string("is an unknown value");
        }
    }

    public static void printObjectInfo(Log log, Object obj) {
        if (obj instanceof DynamicHub) {
            DynamicHub hub = (DynamicHub)obj;
            log.string("is the hub of ").string(hub.getName());
            return;
        }
        log.string("is an object of type ");
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            log.exception(e, 2);
        } else {
            log.string(obj.getClass().getName());
            if (obj instanceof String) {
                String s = (String)obj;
                log.string(": ").string(s, 60);
            } else {
                int layoutEncoding = DynamicHub.fromClass(obj.getClass()).getLayoutEncoding();
                if (LayoutEncoding.isArrayLike(layoutEncoding)) {
                    int length = ArrayLengthNode.arrayLength((Object)obj);
                    log.string(" with length ").signed(length).string(": ");
                    SubstrateDiagnostics.printSomeArrayData(log, obj, length, layoutEncoding);
                }
            }
        }
    }

    private static void printSomeArrayData(Log log, Object obj, int length, int layoutEncoding) {
        int elementSize = LayoutEncoding.getArrayIndexScale(layoutEncoding);
        int arrayBaseOffset = LayoutEncoding.getArrayBaseOffsetAsInt(layoutEncoding);
        int maxPrintedBytes = elementSize == 1 ? 8 : 16;
        int printedElements = UninterruptibleUtils.Math.min(length, maxPrintedBytes / elementSize);
        UnsignedWord curOffset = WordFactory.unsigned((int)arrayBaseOffset);
        UnsignedWord endOffset = curOffset.add(WordFactory.unsigned((int)printedElements).multiply(elementSize));
        while (curOffset.belowThan(endOffset)) {
            switch (elementSize) {
                case 1: {
                    log.zhex(ObjectAccess.readByte((Object)obj, (WordBase)curOffset));
                    break;
                }
                case 2: {
                    log.zhex(ObjectAccess.readShort((Object)obj, (WordBase)curOffset));
                    break;
                }
                case 4: {
                    log.zhex(ObjectAccess.readInt((Object)obj, (WordBase)curOffset));
                    break;
                }
                case 8: {
                    log.zhex(ObjectAccess.readLong((Object)obj, (WordBase)curOffset));
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereAtRuntime();
                }
            }
            log.spaces(1);
            curOffset = curOffset.add(elementSize);
        }
        if (printedElements < length) {
            log.string("...");
        }
    }

    public static void printInformation(Log log, Pointer sp, CodePointer ip) {
        SubstrateDiagnostics.printInformation(log, sp, ip, (RegisterDumper.Context)WordFactory.nullPointer(), false);
    }

    public static void printInformation(Log log, Pointer sp, CodePointer ip, RegisterDumper.Context registerContext, boolean frameHasCalleeSavedRegisters) {
        ErrorContext errorContext = UnsafeStackValue.get(ErrorContext.class);
        errorContext.setStackPointer(sp);
        errorContext.setInstructionPointer(ip);
        errorContext.setRegisterContext(registerContext);
        errorContext.setFrameHasCalleeSavedRegisters(frameHasCalleeSavedRegisters);
        int numDiagnosticThunks = DiagnosticThunkRegistry.singleton().size();
        for (int i = 0; i < numDiagnosticThunks; ++i) {
            DiagnosticThunk thunk = DiagnosticThunkRegistry.singleton().getThunk(i);
            int invocationCount = DiagnosticThunkRegistry.singleton().getInitialInvocationCount(i);
            if (invocationCount > thunk.maxInvocationCount()) continue;
            thunk.printDiagnostics(log, errorContext, 1, invocationCount);
        }
    }

    public static boolean printFatalError(Log log, Pointer sp, CodePointer ip) {
        return SubstrateDiagnostics.printFatalError(log, sp, ip, (RegisterDumper.Context)WordFactory.nullPointer(), false);
    }

    public static boolean printFatalError(Log log, Pointer sp, CodePointer ip, RegisterDumper.Context registerContext, boolean frameHasCalleeSavedRegisters) {
        log.newline();
        while (Options.shouldLoopOnFatalError()) {
            PauseNode.pause();
        }
        if (!SubstrateDiagnostics.fatalErrorState().trySet(log, sp, ip, registerContext, frameHasCalleeSavedRegisters) && !SubstrateDiagnostics.isFatalErrorHandlingThread()) {
            log.string("Error: printFatalError already in progress by another thread.").newline();
            log.newline();
            return false;
        }
        SubstrateDiagnostics.printFatalErrorForCurrentState();
        return true;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="This method is single threaded. The fields 'diagnosticThunkIndex' and 'invocationCount' are only volatile to ensure that the updated field values are written right away.")
    private static void printFatalErrorForCurrentState() {
        assert (SubstrateDiagnostics.isFatalErrorHandlingThread());
        FatalErrorState fatalErrorState = SubstrateDiagnostics.fatalErrorState();
        Log log = fatalErrorState.log;
        if (fatalErrorState.diagnosticThunkIndex >= 0) {
            log.resetIndentation().newline();
        } else {
            fatalErrorState.diagnosticThunkIndex = 0;
        }
        ErrorContext errorContext = fatalErrorState.getErrorContext();
        int numDiagnosticThunks = DiagnosticThunkRegistry.singleton().size();
        while (fatalErrorState.diagnosticThunkIndex < numDiagnosticThunks) {
            int index = fatalErrorState.diagnosticThunkIndex;
            DiagnosticThunk thunk = DiagnosticThunkRegistry.singleton().getThunk(index);
            if (fatalErrorState.invocationCount == 0) {
                fatalErrorState.invocationCount = DiagnosticThunkRegistry.singleton().getInitialInvocationCount(index) - 1;
            }
            while (++fatalErrorState.invocationCount <= thunk.maxInvocationCount()) {
                try {
                    thunk.printDiagnostics(log, errorContext, 3, fatalErrorState.invocationCount);
                    break;
                }
                catch (Throwable e) {
                    SubstrateDiagnostics.dumpException(log, thunk, e);
                }
            }
            ++fatalErrorState.diagnosticThunkIndex;
            fatalErrorState.invocationCount = 0;
        }
        log.flush();
        fatalErrorState.clear();
    }

    static void dumpRuntimeCompilation(Log log) {
        assert (VMOperation.isInProgressAtSafepoint());
        try {
            RuntimeCodeInfoHistory.singleton().printRecentOperations(log, true);
        }
        catch (Exception e) {
            SubstrateDiagnostics.dumpException(log, "DumpCodeCacheHistory", (Throwable)e);
        }
        log.newline();
        try {
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(1);
            boolean allowUnsafeOperations = DiagnosticLevel.unsafeOperationsAllowed(1);
            RuntimeCodeInfoMemory.singleton().printTable(log, allowJavaHeapAccess, allowUnsafeOperations);
        }
        catch (Exception e) {
            SubstrateDiagnostics.dumpException(log, "DumpRuntimeCodeInfoMemory", (Throwable)e);
        }
        log.newline();
        try {
            Deoptimizer.logRecentDeoptimizationEvents(log);
        }
        catch (Exception e) {
            SubstrateDiagnostics.dumpException(log, "DumpRecentDeoptimizations", (Throwable)e);
        }
    }

    private static void dumpException(Log log, DiagnosticThunk thunk, Throwable e) {
        SubstrateDiagnostics.dumpException(log, thunk.getClass().getName(), e);
    }

    private static void dumpException(Log log, String currentDumper, Throwable e) {
        log.newline().string("[!!! Exception while executing ").string(currentDumper).string(": ").string(e.getClass().getName()).string("]");
        log.resetIndentation().newline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    private static long getTotalFrameSize(Pointer sp, CodePointer ip) {
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
        if (deoptFrame != null) {
            return deoptFrame.getSourceTotalFrameSize();
        }
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNonNull()) {
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            try {
                CodeInfo codeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
                long l = SubstrateDiagnostics.getTotalFrameSize0(ip, codeInfo);
                return l;
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
            }
        }
        return -1L;
    }

    @Uninterruptible(reason="Wrap the now safe call to interruptibly look up the frame size.", calleeMustBe=false)
    private static long getTotalFrameSize0(CodePointer ip, CodeInfo codeInfo) {
        return CodeInfoAccess.lookupTotalFrameSize(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip));
    }

    private static void logFrameAnchors(Log log, IsolateThread thread) {
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
        if (anchor.isNull()) {
            log.string("No anchors").newline();
        }
        int printed = 0;
        while (anchor.isNonNull()) {
            if (printed >= 1000) {
                log.string("... (truncated)").newline();
                break;
            }
            log.string("Anchor ").zhex((WordBase)anchor).string(" LastJavaSP ").zhex((WordBase)anchor.getLastJavaSP()).string(" LastJavaIP ").zhex((WordBase)anchor.getLastJavaIP()).newline();
            anchor = anchor.getPreviousAnchor();
            ++printed;
        }
    }

    public static void updateInitialInvocationCounts(String configuration) throws IllegalArgumentException {
        String entry;
        int end;
        int pos = 0;
        while ((end = configuration.indexOf(44, pos)) >= 0) {
            entry = configuration.substring(pos, end);
            SubstrateDiagnostics.updateInitialInvocationCount(entry);
            pos = end + 1;
        }
        entry = configuration.substring(pos);
        SubstrateDiagnostics.updateInitialInvocationCount(entry);
    }

    private static void updateInitialInvocationCount(String entry) throws IllegalArgumentException {
        int pos = entry.indexOf(58);
        if (pos <= 0 || pos == entry.length() - 1) {
            throw new IllegalArgumentException("'" + entry + "' has an invalid format.");
        }
        String pattern = entry.substring(0, pos);
        int initialInvocationCount = SubstrateDiagnostics.parseInvocationCount(entry, pos);
        int matches = 0;
        int numDiagnosticThunks = DiagnosticThunkRegistry.singleton().size();
        for (int i = 0; i < numDiagnosticThunks; ++i) {
            DiagnosticThunk thunk = DiagnosticThunkRegistry.singleton().getThunk(i);
            if (!SubstrateDiagnostics.matches(thunk.getClass().getSimpleName(), pattern)) continue;
            DiagnosticThunkRegistry.singleton().setInitialInvocationCount(i, initialInvocationCount);
            ++matches;
        }
        if (matches == 0) {
            throw new IllegalArgumentException("The pattern '" + entry + "' not match any diagnostic thunk.");
        }
    }

    private static int parseInvocationCount(String entry, int pos) {
        int initialInvocationCount = 0;
        try {
            initialInvocationCount = Integer.parseInt(entry.substring(pos + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (initialInvocationCount < 1) {
            throw new IllegalArgumentException("'" + entry + "' does not specify an integer value >= 1.");
        }
        return initialInvocationCount;
    }

    private static boolean matches(String text, String pattern) {
        assert (pattern.length() > 0) : pattern;
        return SubstrateDiagnostics.matches(text, 0, pattern, 0);
    }

    private static boolean matches(String text, int t, String pattern, int p) {
        int textPos = t;
        int patternPos = p;
        while (textPos < text.length()) {
            if (patternPos >= pattern.length()) {
                return false;
            }
            if (pattern.charAt(patternPos) == '*') {
                if (patternPos + 1 >= pattern.length()) {
                    return true;
                }
                while (textPos < text.length()) {
                    if (SubstrateDiagnostics.matches(text, textPos, pattern, patternPos + 1)) {
                        return true;
                    }
                    ++textPos;
                }
                return false;
            }
            if (text.charAt(textPos) == pattern.charAt(patternPos)) {
                ++textPos;
                ++patternPos;
                continue;
            }
            return false;
        }
        while (patternPos < pattern.length() && pattern.charAt(patternPos) == '*') {
            ++patternPos;
        }
        return patternPos == pattern.length();
    }

    private static Pointer findPotentialReturnAddressPosition(Pointer originalSp) {
        UnsignedWord stackBase = VMThreads.StackBase.get();
        if (stackBase.equal(0)) {
            stackBase = originalSp.add(32);
        }
        int wordSize = ConfigurationValues.getTarget().wordSize;
        Pointer pos = originalSp;
        while (pos.belowThan(stackBase)) {
            CodePointer possibleIp = (CodePointer)pos.readWord(0);
            if (SubstrateDiagnostics.pointsIntoNativeImageCode(possibleIp)) {
                return pos;
            }
            pos = pos.add(wordSize);
        }
        return (Pointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo.")
    private static boolean pointsIntoNativeImageCode(CodePointer possibleIp) {
        return CodeInfoTable.lookupCodeInfo(possibleIp).isNonNull();
    }

    public static class FatalErrorState {
        UninterruptibleUtils.AtomicWord<IsolateThread> diagnosticThread = new UninterruptibleUtils.AtomicWord();
        volatile int diagnosticThunkIndex = -1;
        volatile int invocationCount = 0;
        Log log = null;
        private final byte[] errorContextData;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public FatalErrorState() {
            int errorContextSize = SizeOf.get(ErrorContext.class);
            this.errorContextData = new byte[errorContextSize];
        }

        public ErrorContext getErrorContext() {
            return (ErrorContext)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)this.errorContextData), 0);
        }

        public boolean trySet(Log log, Pointer sp, CodePointer ip, RegisterDumper.Context registerContext, boolean frameHasCalleeSavedRegisters) {
            if (this.diagnosticThread.compareAndSet((IsolateThread)WordFactory.nullPointer(), CurrentIsolate.getCurrentThread())) {
                assert (this.diagnosticThunkIndex == -1);
                assert (this.invocationCount == 0);
                this.log = log;
                ErrorContext errorContext = this.getErrorContext();
                errorContext.setStackPointer(sp);
                errorContext.setInstructionPointer(ip);
                errorContext.setRegisterContext(registerContext);
                errorContext.setFrameHasCalleeSavedRegisters(frameHasCalleeSavedRegisters);
                return true;
            }
            return false;
        }

        public void clear() {
            this.log = null;
            ErrorContext errorContext = this.getErrorContext();
            errorContext.setStackPointer((Pointer)WordFactory.nullPointer());
            errorContext.setInstructionPointer((CodePointer)WordFactory.nullPointer());
            errorContext.setRegisterContext((RegisterDumper.Context)WordFactory.nullPointer());
            errorContext.setFrameHasCalleeSavedRegisters(false);
            this.diagnosticThunkIndex = -1;
            this.invocationCount = 0;
            this.diagnosticThread.set((IsolateThread)WordFactory.nullPointer());
        }
    }

    public static class DiagnosticThunkRegistry {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        final int runtimeCompilationPosition;
        private final List<DiagnosticThunk> thunks = ImageHeapList.create(DiagnosticThunk.class);
        private int[] initialInvocationCount;

        @Fold
        public static synchronized DiagnosticThunkRegistry singleton() {
            if (!ImageSingletons.contains(DiagnosticThunkRegistry.class)) {
                ImageSingletons.add(DiagnosticThunkRegistry.class, (Object)new DiagnosticThunkRegistry());
            }
            return (DiagnosticThunkRegistry)ImageSingletons.lookup(DiagnosticThunkRegistry.class);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        DiagnosticThunkRegistry() {
            this.thunks.add(new DumpRegisters());
            this.thunks.add(new DumpInstructions());
            this.thunks.add(new DumpTopOfCurrentThreadStack());
            this.thunks.add(new DumpCurrentThreadLocals());
            this.thunks.add(new DumpCurrentThreadFrameAnchors());
            this.thunks.add(new DumpCurrentThreadDecodedStackTrace());
            this.thunks.add(new DumpThreads());
            this.thunks.add(new DumpOtherStackTraces());
            this.thunks.add(new DumpCurrentVMOperation());
            this.thunks.add(new DumpVMOperationHistory());
            this.thunks.add(new VMLockSupport.DumpVMMutexes());
            this.thunks.add(new DumpVMInfo());
            this.thunks.add(new DumpMachineInfo());
            if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
                this.thunks.add(new DumpCommandLine());
            }
            this.thunks.add(new DumpCounters());
            this.resizeInitialInvocationCount();
            this.runtimeCompilationPosition = this.thunks.size();
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public synchronized void register(DiagnosticThunk diagnosticThunk) {
            this.thunks.add(diagnosticThunk);
            this.resizeInitialInvocationCount();
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public synchronized void register(int insertPos, DiagnosticThunk ... extraThunks) {
            for (int i = 0; i < extraThunks.length; ++i) {
                this.thunks.add(insertPos + i, extraThunks[i]);
            }
            this.resizeInitialInvocationCount();
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private void resizeInitialInvocationCount() {
            this.initialInvocationCount = new int[this.thunks.size()];
            Arrays.fill(this.initialInvocationCount, 1);
        }

        @Fold
        int size() {
            return this.thunks.size();
        }

        DiagnosticThunk getThunk(int index) {
            return this.thunks.get(index);
        }

        int getInitialInvocationCount(int index) {
            return this.initialInvocationCount[index];
        }

        void setInitialInvocationCount(int index, int value) {
            this.initialInvocationCount[index] = value;
        }
    }

    public static abstract class DiagnosticThunk {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
        public abstract void printDiagnostics(Log var1, ErrorContext var2, int var3, int var4);

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public abstract int maxInvocationCount();
    }

    private static class ImageCodeLocationInfoPrinter {
        private final CodeInfoDecoder.FrameInfoCursor frameInfoCursor = new CodeInfoDecoder.FrameInfoCursor();

        private ImageCodeLocationInfoPrinter() {
        }

        public boolean printLocationInfo(Log log, UnsignedWord value) {
            CodeInfo imageCodeInfo = CodeInfoTable.getImageCodeInfo();
            if (imageCodeInfo.equal((ComparableWord)value)) {
                log.string("is the image CodeInfo object");
                return true;
            }
            UnsignedWord codeInfoEnd = ((UnsignedWord)imageCodeInfo).add(CodeInfoAccess.getSizeOfCodeInfo());
            if (value.aboveOrEqual((UnsignedWord)imageCodeInfo) && value.belowThan(codeInfoEnd)) {
                log.string("points inside the image CodeInfo object ").zhex((WordBase)imageCodeInfo);
                return true;
            }
            if (CodeInfoAccess.contains(imageCodeInfo, (CodePointer)value)) {
                log.string("points into AOT compiled code ");
                FrameInfoQueryResult compilationRoot = this.getCompilationRoot(imageCodeInfo, (CodePointer)value);
                if (compilationRoot != null) {
                    compilationRoot.log(log);
                }
                return true;
            }
            return false;
        }

        private FrameInfoQueryResult getCompilationRoot(CodeInfo imageCodeInfo, CodePointer ip) {
            FrameInfoQueryResult rootInfo = null;
            this.frameInfoCursor.initialize(imageCodeInfo, ip, false);
            while (this.frameInfoCursor.advance()) {
                rootInfo = this.frameInfoCursor.get();
            }
            return rootInfo;
        }
    }

    @RawStructure
    public static interface ErrorContext
    extends PointerBase {
        @RawField
        public Pointer getStackPointer();

        @RawField
        public void setStackPointer(Pointer var1);

        @RawField
        public CodePointer getInstructionPointer();

        @RawField
        public void setInstructionPointer(CodePointer var1);

        @RawField
        public RegisterDumper.Context getRegisterContext();

        @RawField
        public void setRegisterContext(RegisterDumper.Context var1);

        @RawField
        public boolean getFrameHasCalleeSavedRegisters();

        @RawField
        public void setFrameHasCalleeSavedRegisters(boolean var1);
    }

    public static class DiagnosticLevel {
        private static final int JAVA_HEAP_ACCESS = 1;
        private static final int UNSAFE_ACCESS = 2;
        private static final int SAFE = 1;
        private static final int FULL = 3;

        public static boolean javaHeapAccessAllowed(int level) {
            return (level & 1) != 0;
        }

        public static boolean unsafeOperationsAllowed(int level) {
            return (level & 2) != 0;
        }
    }

    @AutomaticallyRegisteredImageSingleton
    public static class Options {
        public static final RuntimeOptionKey<Boolean> LoopOnFatalError = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates}){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                if (ImageSingletons.contains(Options.class)) {
                    Options.singleton().loopOnFatalError = newValue;
                }
            }
        };
        public static final RuntimeOptionKey<Boolean> ImplicitExceptionWithoutStacktraceIsFatal = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates}){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                if (ImageSingletons.contains(Options.class)) {
                    Options.singleton().implicitExceptionWithoutStacktraceIsFatal = newValue;
                }
            }
        };
        private volatile boolean loopOnFatalError = LoopOnFatalError.getValue();
        private boolean implicitExceptionWithoutStacktraceIsFatal = ImplicitExceptionWithoutStacktraceIsFatal.getValue();

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public Options() {
        }

        @Fold
        static Options singleton() {
            return (Options)ImageSingletons.lookup(Options.class);
        }

        public static boolean shouldLoopOnFatalError() {
            return Options.singleton().loopOnFatalError;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean implicitExceptionWithoutStacktraceIsFatal() {
            return Options.singleton().implicitExceptionWithoutStacktraceIsFatal;
        }
    }

    private static class DumpCommandLine
    extends DiagnosticThunk {
        private DumpCommandLine() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            String[] args = ((JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class)).mainArgs;
            if (args != null) {
                log.string("Command line: ");
                for (String arg : args) {
                    log.string("'").string(arg).string("' ");
                }
                log.newline().newline();
            }
        }
    }

    private static class DumpOtherStackTraces
    extends DiagnosticThunk {
        private DumpOtherStackTraces() {
        }

        @Override
        public int maxInvocationCount() {
            return 3;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            if (VMOperation.isInProgressAtSafepoint()) {
                int printed = 0;
                IsolateThread vmThread = VMThreads.firstThreadUnsafe();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread()) {
                        if (printed >= 100000) {
                            log.string("... (truncated)").newline();
                            break;
                        }
                        try {
                            log.string("Thread ").zhex((WordBase)vmThread).string(":").indent(true);
                            DumpOtherStackTraces.printFrameAnchors(log, vmThread);
                            DumpOtherStackTraces.printStackTrace(log, vmThread, invocationCount);
                            log.indent(false);
                        }
                        catch (Exception e) {
                            SubstrateDiagnostics.dumpException(log, this, (Throwable)e);
                        }
                        ++printed;
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
        }

        private static void printFrameAnchors(Log log, IsolateThread vmThread) {
            log.string("Frame anchors:").indent(true);
            SubstrateDiagnostics.logFrameAnchors(log, vmThread);
            log.indent(false);
        }

        private static void printStackTrace(Log log, IsolateThread vmThread, int invocationCount) {
            log.string("Stacktrace:").indent(true);
            JavaStackWalker.walkThread(vmThread, printVisitors[invocationCount - 1].reset(), log);
            log.redent(false);
        }
    }

    private static class DumpCurrentThreadDecodedStackTrace
    extends DiagnosticThunk {
        private DumpCurrentThreadDecodedStackTrace() {
        }

        @Override
        public int maxInvocationCount() {
            return 3;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            Pointer sp = context.getStackPointer();
            CodePointer ip = context.getInstructionPointer();
            log.string("Stacktrace for the failing thread ").zhex((WordBase)CurrentIsolate.getCurrentThread()).string(" (A=AOT compiled, J=JIT compiled, D=deoptimized, i=inlined):").indent(true);
            boolean success = ThreadStackPrinter.printStacktrace(sp, ip, printVisitors[invocationCount - 1].reset(), log);
            if (!success && DiagnosticLevel.unsafeOperationsAllowed(maxDiagnosticLevel)) {
                int expectedStackAlignment = ConfigurationValues.getTarget().stackAlignment;
                if (sp.unsignedRemainder(expectedStackAlignment).notEqual(0) && sp.unsignedRemainder(ConfigurationValues.getTarget().wordSize).equal(0)) {
                    log.newline();
                    log.string("Warning: stack pointer is not aligned to ").signed(expectedStackAlignment).string(" bytes.").newline();
                }
                DumpCurrentThreadDecodedStackTrace.startStackWalkInMostLikelyCaller(log, invocationCount, sp);
            }
            log.indent(false);
        }

        private static void startStackWalkInMostLikelyCaller(Log log, int invocationCount, Pointer originalSp) {
            Pointer returnAddressPos = SubstrateDiagnostics.findPotentialReturnAddressPosition(originalSp);
            if (returnAddressPos.isNull()) {
                return;
            }
            CodePointer possibleIp = (CodePointer)returnAddressPos.readWord(0);
            Pointer sp = returnAddressPos.add(FrameAccess.returnAddressSize());
            log.newline();
            log.string("Starting the stack walk in a possible caller (sp + ").unsigned((WordBase)sp.subtract((UnsignedWord)originalSp)).string("):").newline();
            ThreadStackPrinter.printStacktrace(sp, possibleIp, printVisitors[invocationCount - 1].reset(), log);
        }
    }

    private static class DumpCurrentThreadFrameAnchors
    extends DiagnosticThunk {
        private DumpCurrentThreadFrameAnchors() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            IsolateThread currentThread = CurrentIsolate.getCurrentThread();
            log.string("Java frame anchors for the failing thread ").zhex((WordBase)currentThread).string(":").indent(true);
            SubstrateDiagnostics.logFrameAnchors(log, currentThread);
            log.indent(false);
        }
    }

    private static class DumpCounters
    extends DiagnosticThunk {
        private DumpCounters() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            CounterSupport counters = CounterSupport.singleton();
            if (counters.hasCounters()) {
                log.string("Counters:").indent(true);
                counters.logValues(log);
                log.indent(false);
            }
        }
    }

    public static class DumpMachineInfo
    extends DiagnosticThunk {
        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("Runtime information:").indent(true);
            log.string("CPU cores (OS): ");
            if (!SubstrateOptions.AsyncSignalSafeDiagnostics.getValue().booleanValue() && SubstrateOptions.JNI.getValue().booleanValue()) {
                log.signed(Jvm.JVM_ActiveProcessorCount()).newline();
            } else {
                log.string("unknown").newline();
            }
            log.string("Memory: ");
            if (PhysicalMemory.isInitialized()) {
                log.rational(PhysicalMemory.getCachedSize(), 0x100000L, 0L).string("M").newline();
            } else {
                log.string("unknown").newline();
            }
            log.string("Page size: ").unsigned((WordBase)VirtualMemoryProvider.get().getGranularity()).newline();
            if (!SubstrateOptions.AsyncSignalSafeDiagnostics.getValue().booleanValue()) {
                log.string("VM uptime: ").rational(Isolates.getCurrentUptimeMillis(), 1000L, 3L).string("s").newline();
                log.string("Current timestamp: ").unsigned(System.currentTimeMillis()).newline();
            }
            CodeInfo info = CodeInfoTable.getImageCodeInfo();
            Pointer codeStart = (Pointer)CodeInfoAccess.getCodeStart(info);
            UnsignedWord codeSize = CodeInfoAccess.getCodeSize(info);
            Pointer codeEnd = codeStart.add(codeSize).subtract(1);
            log.string("AOT compiled code: ").zhex((WordBase)codeStart).string(" - ").zhex((WordBase)codeEnd).newline();
            log.indent(false);
        }
    }

    static class DumpVMInfo
    extends DiagnosticThunk {
        DumpVMInfo() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("Build time information:").indent(true);
            VM vm = (VM)ImageSingletons.lookup(VM.class);
            log.string("Version: ").string(vm.version).string(", ").string(vm.info).newline();
            Platform platform = (Platform)ImageSingletons.lookup(Platform.class);
            log.string("Platform: ").string(platform.getOS()).string("/").string(platform.getArchitecture()).newline();
            log.string("Page size: ").unsigned(SubstrateOptions.getPageSize()).newline();
            log.string("Container support: ").bool(Containers.Options.UseContainerSupport.getValue()).newline();
            log.string("CPU features used for AOT compiled code: ").string(DumpVMInfo.getBuildTimeCpuFeatures()).newline();
            log.indent(false);
        }

        @Fold
        static String getBuildTimeCpuFeatures() {
            return String.join((CharSequence)", ", CPUFeatureAccess.singleton().buildtimeCPUFeatures().stream().map(Enum::toString).toList());
        }
    }

    static class DumpRecentDeoptimizations
    extends DiagnosticThunk {
        DumpRecentDeoptimizations() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            Deoptimizer.logRecentDeoptimizationEvents(log);
        }
    }

    static class DumpRuntimeCodeInfoMemory
    extends DiagnosticThunk {
        DumpRuntimeCodeInfoMemory() {
        }

        @Override
        public int maxInvocationCount() {
            return 3;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 3;
            boolean allowUnsafeOperations = DiagnosticLevel.unsafeOperationsAllowed(maxDiagnosticLevel) && invocationCount < 2;
            RuntimeCodeInfoMemory.singleton().printTable(log, allowJavaHeapAccess, allowUnsafeOperations);
        }
    }

    static class DumpCodeCacheHistory
    extends DiagnosticThunk {
        DumpCodeCacheHistory() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
            RuntimeCodeInfoHistory.singleton().printRecentOperations(log, allowJavaHeapAccess);
        }
    }

    private static class DumpVMOperationHistory
    extends DiagnosticThunk {
        private DumpVMOperationHistory() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
            VMOperationControl.printRecentEvents(log, allowJavaHeapAccess);
        }
    }

    private static class DumpCurrentVMOperation
    extends DiagnosticThunk {
        private DumpCurrentVMOperation() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
            VMOperationControl.printCurrentVMOperation(log, allowJavaHeapAccess);
            log.newline();
        }
    }

    private static class DumpCurrentThreadLocals
    extends DiagnosticThunk {
        private DumpCurrentThreadLocals() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            IsolateThread currentThread = CurrentIsolate.getCurrentThread();
            if (SubstrateDiagnostics.isThreadOnlyAttachedForCrashHandler(currentThread)) {
                if (invocationCount == 1) {
                    log.string("The failing thread ").zhex((WordBase)currentThread).string(" does not have a full set of VM thread locals as it is an unattached thread.").newline();
                    log.newline();
                }
            } else {
                log.string("VM thread locals for the failing thread ").zhex((WordBase)currentThread).string(":").indent(true);
                boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
                VMThreadLocalInfos.dumpToLog(log, currentThread, allowJavaHeapAccess);
                log.indent(false);
            }
        }
    }

    private static class DumpThreads
    extends DiagnosticThunk {
        private DumpThreads() {
        }

        @Override
        public int maxInvocationCount() {
            return 3;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowUnsafeOperations;
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
            boolean bl = allowUnsafeOperations = DiagnosticLevel.unsafeOperationsAllowed(maxDiagnosticLevel) && invocationCount < 3;
            if (allowUnsafeOperations || VMOperation.isInProgressAtSafepoint()) {
                log.string("Threads:").indent(true);
                int printed = 0;
                IsolateThread thread = VMThreads.firstThreadUnsafe();
                while (thread.isNonNull()) {
                    if (printed >= 100000) {
                        log.string("... (truncated)").newline();
                        break;
                    }
                    log.zhex((WordBase)thread).spaces(1).string(VMThreads.StatusSupport.getStatusString(thread));
                    int safepointBehavior = VMThreads.SafepointBehavior.getSafepointBehaviorVolatile(thread);
                    log.string(" (").string(VMThreads.SafepointBehavior.toString(safepointBehavior)).string(")");
                    if (allowJavaHeapAccess) {
                        Thread threadObj = PlatformThreads.fromVMThread(thread);
                        if (threadObj == null) {
                            log.string(" null");
                        } else {
                            log.string(" \"").string(threadObj.getName()).string("\" - ").zhex((WordBase)Word.objectToUntrackedPointer((Object)threadObj));
                            if (threadObj.isDaemon()) {
                                log.string(", daemon");
                            }
                        }
                    }
                    log.string(", stack(").zhex((WordBase)VMThreads.StackEnd.get(thread)).string(",").zhex((WordBase)VMThreads.StackBase.get(thread)).string(")");
                    log.newline();
                    ++printed;
                    thread = VMThreads.nextThread(thread);
                }
                log.indent(false);
            }
        }
    }

    static class DumpDeoptStubPointer
    extends DiagnosticThunk {
        DumpDeoptStubPointer() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("DeoptStubPointer address: ").zhex((WordBase)DeoptimizationSupport.getDeoptStubPointer()).newline().newline();
        }
    }

    private static class DumpTopOfCurrentThreadStack
    extends DiagnosticThunk {
        private DumpTopOfCurrentThreadStack() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            Pointer availableBytes;
            Pointer sp = context.getStackPointer();
            UnsignedWord stackEnd = VMThreads.StackEnd.get();
            UnsignedWord stackBase = VMThreads.StackBase.get();
            int wordSize = ConfigurationValues.getTarget().wordSize;
            log.string("Top of stack (sp=").zhex((WordBase)sp).string("):").indent(true);
            int bytesToPrintBelowSp = 32;
            if (stackEnd.notEqual(0) && (availableBytes = sp.subtract(stackEnd)).belowThan(bytesToPrintBelowSp)) {
                bytesToPrintBelowSp = NumUtil.safeToInt((long)availableBytes.rawValue());
            }
            int bytesToPrintAboveSp = 128;
            if (stackBase.notEqual(0)) {
                bytesToPrintAboveSp = 512;
                UnsignedWord availableBytes2 = stackBase.subtract((UnsignedWord)sp);
                if (availableBytes2.belowThan(bytesToPrintAboveSp)) {
                    bytesToPrintAboveSp = NumUtil.safeToInt((long)availableBytes2.rawValue());
                }
            }
            int wordsToPrintBelowSp = bytesToPrintBelowSp / wordSize;
            log.hexdump((PointerBase)sp.subtract(wordsToPrintBelowSp * wordSize), wordSize, wordsToPrintBelowSp, 32);
            log.indent(false);
            log.string("> ").redent(true);
            log.hexdump((PointerBase)sp, wordSize, bytesToPrintAboveSp / wordSize, 32);
            log.indent(false);
            log.newline();
        }
    }

    private static class DumpInstructions
    extends DiagnosticThunk {
        private DumpInstructions() {
        }

        @Override
        public int maxInvocationCount() {
            return 4;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            CodePointer ip = context.getInstructionPointer();
            log.string("Printing instructions (ip=").zhex((WordBase)ip).string("):");
            if (((Pointer)ip).belowThan(VirtualMemoryProvider.get().getGranularity())) {
                Pointer originalSp = context.getStackPointer();
                log.string(" IP is invalid");
                Pointer returnAddressPos = SubstrateDiagnostics.findPotentialReturnAddressPosition(originalSp);
                if (returnAddressPos.isNull()) {
                    log.string(", instructions cannot be printed.").newline();
                    return;
                }
                ip = (CodePointer)returnAddressPos.readWord(0);
                Pointer sp = returnAddressPos.add(FrameAccess.returnAddressSize());
                log.string(", printing instructions (ip=").zhex((WordBase)ip).string(") of the most likely caller (sp + ").unsigned((WordBase)sp.subtract((UnsignedWord)originalSp)).string(") instead");
            }
            log.indent(true);
            if (invocationCount < 4) {
                int bytesToPrint = 1024 >> invocationCount * 2;
                DumpInstructions.hexDump(log, ip, bytesToPrint, bytesToPrint);
            } else if (invocationCount == 4) {
                DumpInstructions.hexDump(log, ip, 0, ConfigurationValues.getTarget().wordSize);
            }
            log.indent(false).newline();
        }

        private static void hexDump(Log log, CodePointer ip, int bytesBefore, int bytesAfter) {
            log.hexdump((PointerBase)((Pointer)ip).subtract(bytesBefore), 1, bytesBefore);
            log.indent(false);
            log.string("> ").redent(true);
            log.hexdump((PointerBase)ip, 1, bytesAfter);
        }
    }

    private static class DumpRegisters
    extends DiagnosticThunk {
        private DumpRegisters() {
        }

        @Override
        public int maxInvocationCount() {
            return 4;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowUnsafeOperations;
            boolean printLocationInfo = invocationCount < 4;
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 3;
            boolean bl = allowUnsafeOperations = DiagnosticLevel.unsafeOperationsAllowed(maxDiagnosticLevel) && invocationCount < 2;
            if (context.getRegisterContext().isNonNull()) {
                log.string("General purpose register values:").indent(true);
                RegisterDumper.singleton().dumpRegisters(log, context.getRegisterContext(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
                log.indent(false);
            } else if (CalleeSavedRegisters.supportedByPlatform() && context.getFrameHasCalleeSavedRegisters()) {
                CalleeSavedRegisters.singleton().dumpRegisters(log, context.getStackPointer(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
            }
        }
    }
}

