/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.InitKind;
import java.lang.reflect.Proxy;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.java.LambdaUtils;

class AllowAllHostedUsagesClassInitializationSupport
extends ClassInitializationSupport {
    AllowAllHostedUsagesClassInitializationSupport(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        super(metaAccess, loader);
    }

    public void initializeAtBuildTime(Class<?> aClass, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> cur = aClass;
        do {
            this.classInitializationConfiguration.insert(cur.getTypeName(), InitKind.BUILD_TIME, (String)(cur == aClass ? reason : "super type of " + aClass.getTypeName()), true);
            this.initializeInterfacesAtBuildTime(cur.getInterfaces(), "interface of " + aClass.getTypeName());
        } while ((cur = cur.getSuperclass()) != null);
    }

    private void initializeInterfacesAtBuildTime(Class<?>[] interfaces, String reason) {
        for (Class<?> iface : interfaces) {
            if (this.metaAccess.lookupJavaType(iface).declaresDefaultMethods()) {
                this.classInitializationConfiguration.insert(iface.getTypeName(), InitKind.BUILD_TIME, reason, true);
            }
            this.initializeInterfacesAtBuildTime(iface.getInterfaces(), reason);
        }
    }

    public void initializeAtRunTime(Class<?> clazz, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.RUN_TIME, reason, true);
    }

    public void rerunInitialization(Class<?> clazz, String reason) {
        this.initializeAtRunTime(clazz, reason);
    }

    @Override
    public void rerunInitialization(String name, String reason) {
        this.initializeAtRunTime(name, reason);
    }

    @Override
    String reasonForClass(Class<?> clazz) {
        InitKind initKind = (InitKind)((Object)this.classInitKinds.get(clazz));
        String reason = this.classInitializationConfiguration.lookupReason(clazz.getTypeName());
        if (initKind.isRunTime()) {
            return "classes are initialized at run time by default";
        }
        if (reason != null) {
            return reason;
        }
        throw VMError.shouldNotReachHere("Must be either proven or specified");
    }

    @Override
    public void forceInitializeHosted(Class<?> clazz, String reason, boolean allowInitializationErrors) {
        if (clazz == null) {
            return;
        }
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.BUILD_TIME, reason, true);
        InitKind initKind = this.ensureClassInitialized(clazz, allowInitializationErrors);
        this.classInitKinds.put(clazz, initKind);
        this.forceInitializeHosted(clazz.getSuperclass(), "super type of " + clazz.getTypeName(), allowInitializationErrors);
        this.forceInitializeInterfaces(clazz.getInterfaces(), "super type of " + clazz.getTypeName());
    }

    private void forceInitializeInterfaces(Class<?>[] interfaces, String reason) {
        for (Class<?> iface : interfaces) {
            if (this.metaAccess.lookupJavaType(iface).declaresDefaultMethods()) {
                this.classInitializationConfiguration.insert(iface.getTypeName(), InitKind.BUILD_TIME, reason, true);
                this.ensureClassInitialized(iface, false);
                this.classInitKinds.put(iface, InitKind.BUILD_TIME);
            }
            this.forceInitializeInterfaces(iface.getInterfaces(), "super type of " + iface.getTypeName());
        }
    }

    @Override
    boolean checkDelayedInitialization() {
        return true;
    }

    @Override
    InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz, true);
    }

    InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoize) {
        InitKind existing = (InitKind)((Object)this.classInitKinds.get(clazz));
        if (existing != null) {
            return existing;
        }
        if (clazz.isPrimitive()) {
            this.forceInitializeHosted(clazz, "primitive types are initialized at build time", false);
            return InitKind.BUILD_TIME;
        }
        if (clazz.isArray()) {
            this.forceInitializeHosted(clazz, "arrays are initialized at build time", false);
            return InitKind.BUILD_TIME;
        }
        InitKind specifiedInitKind = this.specifiedInitKindFor(clazz);
        InitKind clazzResult = specifiedInitKind != null ? specifiedInitKind : InitKind.RUN_TIME;
        InitKind superResult = InitKind.BUILD_TIME;
        if (clazz.getSuperclass() != null) {
            superResult = superResult.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoize));
        }
        if ((superResult = superResult.max(this.processInterfaces(clazz, memoize))) == InitKind.BUILD_TIME && (Proxy.isProxyClass(clazz) || LambdaUtils.isLambdaType((ResolvedJavaType)this.metaAccess.lookupJavaType(clazz)))) {
            boolean allInterfacesSpecifiedAsBuildTime = true;
            for (Class iface : AllowAllHostedUsagesClassInitializationSupport.allInterfaces(clazz)) {
                if (this.specifiedInitKindFor(iface) == InitKind.BUILD_TIME) continue;
                allInterfacesSpecifiedAsBuildTime = false;
                break;
            }
            if (allInterfacesSpecifiedAsBuildTime) {
                this.forceInitializeHosted(clazz, "proxy/lambda classes with all interfaces explicitly marked as --initialize-at-build-time are also initialized at build time", false);
                return InitKind.BUILD_TIME;
            }
        }
        InitKind result = superResult.max(clazzResult);
        if (memoize) {
            InitKind previous;
            if (!result.isRunTime()) {
                result = result.max(this.ensureClassInitialized(clazz, false));
            }
            if ((previous = this.classInitKinds.putIfAbsent(clazz, result)) != null && previous != result) {
                throw VMError.shouldNotReachHere("Conflicting class initialization kind: " + previous + " != " + result + " for " + clazz);
            }
        }
        return result;
    }

    private InitKind processInterfaces(Class<?> clazz, boolean memoizeEager) {
        InitKind result = InitKind.BUILD_TIME;
        for (Class<?> iface : clazz.getInterfaces()) {
            result = this.metaAccess.lookupJavaType(iface).declaresDefaultMethods() ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager)) : result.max(this.processInterfaces(iface, memoizeEager));
        }
        return result;
    }

    @Override
    void doLateInitialization(AnalysisUniverse aUniverse, AnalysisMetaAccess aMetaAccess) {
    }
}

