/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.JavaMonitorWaitEvent;
import com.oracle.svm.core.thread.JavaThreads;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import jdk.internal.misc.Unsafe;

abstract class JavaMonitorQueuedSynchronizer {
    static final int WAITING = 1;
    static final int CANCELLED = Integer.MIN_VALUE;
    static final int COND = 2;
    protected static final int SPIN_SUCCESS = -1;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile long state;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long STATE = U.objectFieldOffset(JavaMonitorQueuedSynchronizer.class, "state");
    private static final long HEAD = U.objectFieldOffset(JavaMonitorQueuedSynchronizer.class, "head");
    private static final long TAIL = U.objectFieldOffset(JavaMonitorQueuedSynchronizer.class, "tail");

    JavaMonitorQueuedSynchronizer() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected final long getState() {
        return this.state;
    }

    protected final void setState(long newState) {
        this.state = newState;
    }

    protected abstract long getAcquisitions();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected final boolean compareAndSetState(long expect, long update) {
        return U.compareAndSetLong(this, STATE, expect, update);
    }

    private boolean casTail(Node c, Node v) {
        return U.compareAndSetReference(this, TAIL, c, v);
    }

    private Node tryInitializeHead() {
        ExclusiveNode h = null;
        while (true) {
            Node t;
            if ((t = this.tail) != null) {
                return t;
            }
            if (this.head != null) {
                Thread.onSpinWait();
                continue;
            }
            if (h == null) {
                try {
                    h = JavaMonitorQueuedSynchronizer.allocateExclusiveNode();
                }
                catch (OutOfMemoryError oome) {
                    return null;
                }
            }
            if (U.compareAndSetReference(this, HEAD, null, h)) break;
        }
        this.tail = h;
        return this.tail;
    }

    final void enqueue(ConditionNode node) {
        if (node != null) {
            boolean unpark;
            block5: {
                Node t;
                unpark = false;
                do {
                    if ((t = this.tail) == null && (t = this.tryInitializeHead()) == null) {
                        unpark = true;
                        break block5;
                    }
                    node.setPrevRelaxed(t);
                } while (!this.casTail(t, node));
                t.next = node;
                if (t.status < 0) {
                    unpark = true;
                }
            }
            if (unpark) {
                LockSupport.unpark(node.waiter);
            }
        }
    }

    final boolean isEnqueued(Node node) {
        Node t = this.tail;
        while (t != null) {
            if (t == node) {
                return true;
            }
            t = t.prev;
        }
        return false;
    }

    private static void signalNext(Node h) {
        Node s;
        if (h != null && (s = h.next) != null && s.status != 0) {
            s.getAndUnsetStatus(1);
            LockSupport.unpark(s.waiter);
        }
    }

    protected boolean hasReleaseSuccessor() {
        Node h = this.head;
        if (h == null) {
            return false;
        }
        Node s = h.next;
        return s != null && s.status != 0;
    }

    protected void signalReleaseSuccessor() {
        JavaMonitorQueuedSynchronizer.signalNext(this.head);
    }

    protected int trySpinAcquire(int spins, long arg) {
        assert (spins > 0);
        if (this.tryAcquire(arg)) {
            return -1;
        }
        return spins - 1;
    }

    protected int getSpinAttempts(int parks) {
        if (parks < 0 || parks > 8) {
            return 255;
        }
        return (1 << parks) - 1;
    }

    final int acquire(Node node, long arg) {
        Thread current = Thread.currentThread();
        int parks = 0;
        int spins = this.getSpinAttempts(parks);
        boolean first = false;
        Node pred = null;
        while (true) {
            Node t;
            if (!first && (pred = node == null ? null : node.prev) != null && !(first = this.head == pred)) {
                if (pred.status < 0) {
                    this.cleanQueue();
                    continue;
                }
                if (pred.prev == null) {
                    Thread.onSpinWait();
                    continue;
                }
            }
            if (first || pred == null) {
                boolean acquired;
                try {
                    if (spins > 0) {
                        boolean bl = acquired = (spins = this.trySpinAcquire(spins, arg)) == -1;
                        assert (!acquired || this.isHeldExclusively());
                    } else {
                        acquired = this.tryAcquire(arg);
                    }
                }
                catch (Throwable ex) {
                    this.cancelAcquire(node);
                    throw ex;
                }
                if (acquired) {
                    if (first) {
                        node.prev = null;
                        this.head = node;
                        pred.next = null;
                        node.waiter = null;
                    }
                    return 1;
                }
            }
            if ((t = this.tail) == null) {
                if (this.tryInitializeHead() != null) continue;
                return this.acquireOnOOME(arg);
            }
            if (node == null) {
                try {
                    node = JavaMonitorQueuedSynchronizer.allocateExclusiveNode();
                }
                catch (OutOfMemoryError oome) {
                    return this.acquireOnOOME(arg);
                }
            }
            if (pred == null) {
                node.waiter = current;
                node.setPrevRelaxed(t);
                if (!this.casTail(t, node)) {
                    node.setPrevRelaxed(null);
                    continue;
                }
                t.next = node;
                continue;
            }
            if (first && spins > 0) {
                Thread.onSpinWait();
                continue;
            }
            if (node.status == 0) {
                node.status = 1;
                continue;
            }
            spins = this.getSpinAttempts(++parks);
            try {
                LockSupport.park(this);
            }
            catch (Error | RuntimeException ex) {
                this.cancelAcquire(node);
                throw ex;
            }
            node.clearStatus();
        }
    }

    private int acquireOnOOME(long arg) {
        long nanos = 1L;
        while (!this.tryAcquire(arg)) {
            U.park(false, nanos);
            if (nanos >= 0x40000000L) continue;
            nanos <<= 1;
        }
        return 1;
    }

    private void cleanQueue() {
        block0: while (true) {
            Node q = this.tail;
            Node s = null;
            while (true) {
                Node p;
                if (q == null || (p = q.prev) == null) {
                    return;
                }
                if (s != null ? s.prev != q || s.status < 0 : this.tail != q) continue block0;
                if (q.status < 0) {
                    if (!(s == null ? this.casTail(q, p) : s.casPrev(q, p)) || q.prev != p) continue block0;
                    p.casNext(q, s);
                    if (p.prev != null) continue block0;
                    JavaMonitorQueuedSynchronizer.signalNext(p);
                    continue block0;
                }
                Node n = p.next;
                if (n != q) {
                    if (n == null || q.prev != p) continue block0;
                    p.casNext(n, q);
                    if (p.prev != null) continue block0;
                    JavaMonitorQueuedSynchronizer.signalNext(p);
                    continue block0;
                }
                s = q;
                q = q.prev;
            }
            break;
        }
    }

    @NeverInline(value="Can be removed once GR-51172 is resolved")
    private static ExclusiveNode allocateExclusiveNode() {
        return new ExclusiveNode();
    }

    private int cancelAcquire(Node node) {
        if (node != null) {
            node.waiter = null;
            node.status = Integer.MIN_VALUE;
            if (node.prev != null) {
                this.cleanQueue();
            }
        }
        return 0;
    }

    protected abstract boolean tryAcquire(long var1);

    protected abstract boolean tryRelease(long var1);

    protected abstract boolean isHeldExclusively();

    protected final void acquire(long arg) {
        if (!this.tryAcquire(arg)) {
            this.acquire(null, arg);
        }
    }

    protected final boolean release(long arg) {
        if (this.tryRelease(arg)) {
            JavaMonitorQueuedSynchronizer.signalNext(this.head);
            return true;
        }
        return false;
    }

    static abstract class Node {
        volatile Node prev;
        volatile Node next;
        Thread waiter;
        volatile int status;
        private static final long STATUS = U.objectFieldOffset(Node.class, "status");
        private static final long NEXT = U.objectFieldOffset(Node.class, "next");
        private static final long PREV = U.objectFieldOffset(Node.class, "prev");

        Node() {
        }

        final boolean casPrev(Node c, Node v) {
            return U.weakCompareAndSetReference(this, PREV, c, v);
        }

        final boolean casNext(Node c, Node v) {
            return U.weakCompareAndSetReference(this, NEXT, c, v);
        }

        final int getAndUnsetStatus(int v) {
            return U.getAndBitwiseAndInt(this, STATUS, ~v);
        }

        final void setPrevRelaxed(Node p) {
            U.putReference(this, PREV, p);
        }

        final void setStatusRelaxed(int s) {
            U.putInt(this, STATUS, s);
        }

        final void clearStatus() {
            U.putIntOpaque(this, STATUS, 0);
        }
    }

    static final class ExclusiveNode
    extends Node {
        ExclusiveNode() {
        }
    }

    static final class ConditionNode
    extends Node {
        ConditionNode nextWaiter;
        long notifierJfrTid;

        ConditionNode() {
        }

        public boolean isReleasable() {
            return this.status <= 1 || JavaThreads.isInterrupted(Thread.currentThread());
        }

        public boolean block() {
            while (!this.isReleasable()) {
                LockSupport.park(this);
            }
            return true;
        }
    }

    public final class JavaMonitorConditionObject {
        private transient ConditionNode firstWaiter;
        private transient ConditionNode lastWaiter;
        static final long OOME_COND_WAIT_DELAY = 10000000L;

        JavaMonitorConditionObject() {
        }

        private void doSignal(ConditionNode first, boolean all) {
            while (first != null) {
                ConditionNode next = first.nextWaiter;
                this.firstWaiter = next;
                if (this.firstWaiter == null) {
                    this.lastWaiter = null;
                } else {
                    first.nextWaiter = null;
                }
                if ((first.getAndUnsetStatus(2) & 2) != 0) {
                    first.notifierJfrTid = SubstrateJVM.getCurrentThreadId();
                    JavaMonitorQueuedSynchronizer.this.enqueue(first);
                    if (!all) break;
                }
                first = next;
            }
        }

        public void signal() {
            ConditionNode first = this.firstWaiter;
            if (!JavaMonitorQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            if (first != null) {
                this.doSignal(first, false);
            }
        }

        public void signalAll() {
            ConditionNode first = this.firstWaiter;
            if (!JavaMonitorQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            if (first != null) {
                this.doSignal(first, true);
            }
        }

        private long enableWait(ConditionNode node) {
            if (JavaMonitorQueuedSynchronizer.this.isHeldExclusively()) {
                node.waiter = Thread.currentThread();
                node.setStatusRelaxed(3);
                ConditionNode last = this.lastWaiter;
                if (last == null) {
                    this.firstWaiter = node;
                } else {
                    last.nextWaiter = node;
                }
                this.lastWaiter = node;
                long savedAcquisitions = JavaMonitorQueuedSynchronizer.this.getAcquisitions();
                if (JavaMonitorQueuedSynchronizer.this.release(savedAcquisitions)) {
                    return savedAcquisitions;
                }
            }
            node.status = Integer.MIN_VALUE;
            throw new IllegalMonitorStateException();
        }

        private boolean canReacquire(ConditionNode node) {
            Node p;
            return node != null && (p = node.prev) != null && (p.next == node || JavaMonitorQueuedSynchronizer.this.isEnqueued(node));
        }

        private void unlinkCancelledWaiters(ConditionNode node) {
            if (node == null || node.nextWaiter != null || node == this.lastWaiter) {
                ConditionNode w = this.firstWaiter;
                ConditionNode trail = null;
                while (w != null) {
                    ConditionNode next = w.nextWaiter;
                    if ((w.status & 2) == 0) {
                        w.nextWaiter = null;
                        if (trail == null) {
                            this.firstWaiter = next;
                        } else {
                            trail.nextWaiter = next;
                        }
                        if (next == null) {
                            this.lastWaiter = trail;
                        }
                    } else {
                        trail = w;
                    }
                    w = next;
                }
            }
        }

        private ConditionNode newConditionNode() {
            long savedState;
            if (JavaMonitorQueuedSynchronizer.this.tryInitializeHead() != null) {
                try {
                    return JavaMonitorConditionObject.allocateConditionNode();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
            }
            if (!JavaMonitorQueuedSynchronizer.this.isHeldExclusively() || !JavaMonitorQueuedSynchronizer.this.release(savedState = JavaMonitorQueuedSynchronizer.this.getState())) {
                throw new IllegalMonitorStateException();
            }
            U.park(false, 10000000L);
            JavaMonitorQueuedSynchronizer.this.acquireOnOOME(savedState);
            return null;
        }

        @NeverInline(value="Can be removed once GR-51172 is resolved")
        private static ConditionNode allocateConditionNode() {
            return new ConditionNode();
        }

        public void await(Object obj) throws InterruptedException {
            long startTicks = JfrTicks.elapsedTicks();
            if (Thread.interrupted()) {
                JavaMonitorWaitEvent.emit(startTicks, obj, 0L, 0L, false);
                throw new InterruptedException();
            }
            ConditionNode node = this.newConditionNode();
            if (node == null) {
                return;
            }
            long savedAcquisitions = this.enableWait(node);
            boolean interrupted = false;
            boolean cancelled = false;
            while (!this.canReacquire(node)) {
                if (interrupted |= Thread.interrupted()) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                if ((node.status & 2) != 0) {
                    node.block();
                    continue;
                }
                Thread.onSpinWait();
            }
            node.clearStatus();
            JavaMonitorWaitEvent.emit(startTicks, obj, node.notifierJfrTid, 0L, false);
            JavaMonitorQueuedSynchronizer.this.acquire(node, savedAcquisitions);
            if (interrupted) {
                if (cancelled) {
                    this.unlinkCancelledWaiters(node);
                    throw new InterruptedException();
                }
                Thread.currentThread().interrupt();
            }
        }

        public boolean await(Object obj, long time, TimeUnit unit) throws InterruptedException {
            long startTicks = JfrTicks.elapsedTicks();
            long nanosTimeout = unit.toNanos(time);
            if (Thread.interrupted()) {
                JavaMonitorWaitEvent.emit(startTicks, obj, 0L, 0L, false);
                throw new InterruptedException();
            }
            ConditionNode node = this.newConditionNode();
            if (node == null) {
                return false;
            }
            long savedAcquisitions = this.enableWait(node);
            long nanos = nanosTimeout < 0L ? 0L : nanosTimeout;
            long deadline = System.nanoTime() + nanos;
            boolean cancelled = false;
            boolean interrupted = false;
            while (!this.canReacquire(node)) {
                if ((interrupted |= Thread.interrupted()) || (nanos = deadline - System.nanoTime()) <= 0L) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                LockSupport.parkNanos(this, nanos);
            }
            node.clearStatus();
            JavaMonitorWaitEvent.emit(startTicks, obj, node.notifierJfrTid, time, cancelled);
            JavaMonitorQueuedSynchronizer.this.acquire(node, savedAcquisitions);
            if (cancelled) {
                this.unlinkCancelledWaiters(node);
                if (interrupted) {
                    throw new InterruptedException();
                }
            } else if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return !cancelled;
        }
    }
}

