/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

public enum PerfVariability {
    INVALID("Invalid", 0),
    CONSTANT("Constant", 1),
    MONOTONIC("Monotonic", 2),
    VARIABLE("Variable", 3);

    private final String name;
    private final int value;

    public String toString() {
        return this.name;
    }

    public int intValue() {
        return this.value;
    }

    public static PerfVariability fromInt(int value) {
        switch (value) {
            case 1: {
                return CONSTANT;
            }
            case 2: {
                return MONOTONIC;
            }
            case 3: {
                return VARIABLE;
            }
        }
        return INVALID;
    }

    private PerfVariability(String name, int value) {
        this.name = name;
        this.value = value;
    }
}

