/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public class SubstrateControlFlowIntegrity {
    public CFIOptions getCFIMode() {
        return CFIOptions.NONE;
    }

    public Register getCFITargetRegister() {
        throw VMError.shouldNotReachHere("No CFI Target Register is available");
    }

    public boolean continuationsSupported() {
        return true;
    }

    @Fold
    public static SubstrateControlFlowIntegrity singleton() {
        return (SubstrateControlFlowIntegrity)ImageSingletons.lookup(SubstrateControlFlowIntegrity.class);
    }

    @Fold
    public static boolean enabled() {
        CFIOptions cfiMode = SubstrateControlFlowIntegrity.singleton().getCFIMode();
        return cfiMode != CFIOptions.NONE;
    }

    @Fold
    public static boolean useSoftwareCFI() {
        CFIOptions cfiMode = SubstrateControlFlowIntegrity.singleton().getCFIMode();
        return cfiMode == CFIOptions.SW || cfiMode == CFIOptions.SW_NONATIVE;
    }

    public static enum CFIOptions {
        NONE,
        HW,
        SW,
        SW_NONATIVE;

    }
}

