/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jni.CallVariant;
import com.oracle.svm.core.jni.functions.JNIFunctionTables;
import com.oracle.svm.core.jni.functions.JNIFunctions;
import com.oracle.svm.core.jni.functions.JNIFunctionsJDK19OrLater;
import com.oracle.svm.core.jni.functions.JNIInvocationInterface;
import com.oracle.svm.core.jni.headers.JNIInvokeInterface;
import com.oracle.svm.core.jni.headers.JNINativeInterface;
import com.oracle.svm.core.jni.headers.JNINativeInterfaceJDK19OrLater;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.jni.JNICallTrampolineMethod;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;

public class JNIFunctionTablesFeature
implements Feature {
    private final EnumSet<JavaKind> jniKinds = EnumSet.of(JavaKind.Object, new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double, JavaKind.Void});
    private StructInfo functionTableMetadata;
    private StructInfo functionTableMetadataJDK19OrLater;
    private StructInfo invokeInterfaceMetadata;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(JNIAccessFeature.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)arg;
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        JNIFunctionTables.create();
        NativeLibraries nativeLibraries = access.getNativeLibraries();
        AnalysisType invokeInterface = metaAccess.lookupJavaType(JNIInvokeInterface.class);
        this.invokeInterfaceMetadata = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)invokeInterface);
        AnalysisType functionTable = metaAccess.lookupJavaType(JNINativeInterface.class);
        this.functionTableMetadata = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)functionTable);
        if (JavaVersionUtil.JAVA_SPEC > 17) {
            this.functionTableMetadataJDK19OrLater = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)metaAccess.lookupJavaType(JNINativeInterfaceJDK19OrLater.class));
        }
        AnalysisType invokes = metaAccess.lookupJavaType(JNIInvocationInterface.class);
        AnalysisType exports = metaAccess.lookupJavaType(JNIInvocationInterface.Exports.class);
        AnalysisType functions = metaAccess.lookupJavaType(JNIFunctions.class);
        AnalysisType functionsJDK19OrLater = JavaVersionUtil.JAVA_SPEC <= 17 ? null : metaAccess.lookupJavaType(JNIFunctionsJDK19OrLater.class);
        Stream analysisMethods = Stream.of(invokes, functions, functionsJDK19OrLater, exports).filter(type -> type != null).flatMap(type -> Stream.of(type.getDeclaredMethods(false)));
        Stream<AnalysisMethod> unimplementedMethods = Stream.of((AnalysisMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)metaAccess, JNIFunctions.UnimplementedWithJNIEnvArgument.class), (AnalysisMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)metaAccess, JNIFunctions.UnimplementedWithJavaVMArgument.class));
        Stream.concat(analysisMethods, unimplementedMethods).forEach(method -> {
            CEntryPoint annotation = (CEntryPoint)AnnotationAccess.getAnnotation((AnnotatedElement)method, CEntryPoint.class);
            assert (annotation != null) : "only entry points allowed in class";
            CEntryPointCallStubSupport.singleton().registerStubForMethod((AnalysisMethod)method, () -> {
                CEntryPointData data = CEntryPointData.create((ResolvedJavaMethod)method);
                if (!SubstrateOptions.JNIExportSymbols.getValue().booleanValue() && data.getPublishAs() != CEntryPoint.Publish.NotPublished) {
                    data = data.copyWithPublishAs(CEntryPoint.Publish.NotPublished);
                }
                return data;
            });
        });
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        this.fillJNIInvocationInterfaceTable(access);
        this.fillJNIFunctionsTable(access);
    }

    private static CFunctionPointer prepareCallTrampoline(FeatureImpl.CompilationAccessImpl access, CallVariant variant, boolean nonVirtual) {
        JNICallTrampolineMethod trampolineMethod = JNIAccessFeature.singleton().getCallTrampolineMethod(variant, nonVirtual);
        AnalysisMethod analysisTrampoline = access.getUniverse().getBigBang().getUniverse().lookup((JavaMethod)trampolineMethod);
        HostedMethod hostedTrampoline = access.getUniverse().lookup((JavaMethod)analysisTrampoline);
        hostedTrampoline.compilationInfo.setCustomParseFunction(trampolineMethod.createCustomParseFunction());
        hostedTrampoline.compilationInfo.setCustomCompileFunction(trampolineMethod.createCustomCompileFunction());
        return new MethodPointer(hostedTrampoline);
    }

    private static ResolvedJavaMethod getSingleMethod(MetaAccessProvider metaAccess, Class<?> holder) {
        ResolvedJavaMethod[] methods = metaAccess.lookupJavaType(holder).getDeclaredMethods(false);
        assert (methods.length == 1);
        return methods[0];
    }

    private static CFunctionPointer getStubFunctionPointer(FeatureImpl.CompilationAccessImpl access, HostedMethod method) {
        AnalysisMethod stub = CEntryPointCallStubSupport.singleton().getStubForMethod(method.getWrapped());
        return new MethodPointer(access.getUniverse().lookup((JavaMethod)stub));
    }

    private void fillJNIInvocationInterfaceTable(FeatureImpl.CompilationAccessImpl access) {
        CFunctionPointer unimplementedWithJavaVMArgument = JNIFunctionTablesFeature.getStubFunctionPointer(access, (HostedMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)access.getMetaAccess(), JNIFunctions.UnimplementedWithJavaVMArgument.class));
        JNIFunctionTables.singleton().initInvokeInterfaceTable(unimplementedWithJavaVMArgument, access);
        ResolvedJavaType invokes = access.getMetaAccess().lookupJavaType((Class)JNIInvocationInterface.class);
        for (HostedMethod method : invokes.getDeclaredMethods(false)) {
            StructFieldInfo field = JNIFunctionTablesFeature.findFieldFor(this.invokeInterfaceMetadata, method.getName());
            int offset = field.getOffsetInfo().getProperty();
            JNIFunctionTables.singleton().initInvokeInterfaceEntry(offset, JNIFunctionTablesFeature.getStubFunctionPointer(access, method));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fillJNIFunctionsTable(FeatureImpl.CompilationAccessImpl access) {
        JNIFunctionTables tables = JNIFunctionTables.singleton();
        CFunctionPointer unimplementedWithJNIEnvArgument = JNIFunctionTablesFeature.getStubFunctionPointer(access, (HostedMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)access.getMetaAccess(), JNIFunctions.UnimplementedWithJNIEnvArgument.class));
        tables.initFunctionTable(unimplementedWithJNIEnvArgument, access);
        ResolvedJavaType functions = access.getMetaAccess().lookupJavaType((Class)JNIFunctions.class);
        for (HostedMethod hostedMethod : functions.getDeclaredMethods(false)) {
            StructFieldInfo field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, hostedMethod.getName());
            int offset = field.getOffsetInfo().getProperty();
            tables.initFunctionEntry(offset, JNIFunctionTablesFeature.getStubFunctionPointer(access, hostedMethod));
        }
        if (JavaVersionUtil.JAVA_SPEC > 17) {
            void var8_14;
            ResolvedJavaType resolvedJavaType = access.getMetaAccess().lookupJavaType((Class)JNIFunctionsJDK19OrLater.class);
            HostedMethod[] hostedMethodArray = resolvedJavaType.getDeclaredMethods(false);
            int n = hostedMethodArray.length;
            boolean bl = false;
            while (var8_14 < n) {
                HostedMethod method2 = hostedMethodArray[var8_14];
                StructFieldInfo field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadataJDK19OrLater, method2.getName());
                int offset = field.getOffsetInfo().getProperty();
                tables.initFunctionEntry(offset, JNIFunctionTablesFeature.getStubFunctionPointer(access, method2));
                ++var8_14;
            }
        }
        for (CallVariant callVariant : CallVariant.values()) {
            CFunctionPointer trampoline = JNIFunctionTablesFeature.prepareCallTrampoline(access, callVariant, false);
            String suffix = callVariant == CallVariant.ARRAY ? "A" : (callVariant == CallVariant.VA_LIST ? "V" : "");
            CFunctionPointer nonvirtualTrampoline = JNIFunctionTablesFeature.prepareCallTrampoline(access, callVariant, true);
            for (JavaKind kind : this.jniKinds) {
                String[] prefixes;
                for (String prefix : prefixes = new String[]{"Call", "CallStatic"}) {
                    StructFieldInfo field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, prefix + kind.name() + "Method" + suffix);
                    int offset = field.getOffsetInfo().getProperty();
                    tables.initFunctionEntry(offset, trampoline);
                }
                StructFieldInfo field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, "CallNonvirtual" + kind.name() + "Method" + suffix);
                int offset = field.getOffsetInfo().getProperty();
                tables.initFunctionEntry(offset, nonvirtualTrampoline);
            }
            StructFieldInfo field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, "NewObject" + suffix);
            int offset = field.getOffsetInfo().getProperty();
            tables.initFunctionEntry(offset, trampoline);
        }
    }

    private static StructFieldInfo findFieldFor(StructInfo info, String name) {
        for (ElementInfo element : info.getChildren()) {
            StructFieldInfo field;
            if (!(element instanceof StructFieldInfo) || !(field = (StructFieldInfo)element).getName().equals(name)) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Cannot find JNI function table field for: " + name);
    }
}

