/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.windows.headers.MemoryAPI;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={StackOverflowCheck.PlatformSupport.class})
final class WindowsStackOverflowSupport
implements StackOverflowCheck.PlatformSupport {
    WindowsStackOverflowSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean lookupStack(WordPointer stackBasePtr, WordPointer stackEndPtr) {
        int sizeOfMInfo = SizeOf.get(MemoryAPI.MEMORY_BASIC_INFORMATION.class);
        MemoryAPI.MEMORY_BASIC_INFORMATION minfo = (MemoryAPI.MEMORY_BASIC_INFORMATION)StackValue.get((int)sizeOfMInfo);
        MemoryAPI.VirtualQuery(minfo, minfo, WordFactory.unsigned((int)sizeOfMInfo));
        Pointer bottom = (Pointer)minfo.AllocationBase();
        stackEndPtr.write((WordBase)bottom);
        UnsignedWord stackSize = minfo.RegionSize();
        while (true) {
            MemoryAPI.VirtualQuery((PointerBase)bottom.add(stackSize), minfo, WordFactory.unsigned((int)sizeOfMInfo));
            if (!bottom.equal((ComparableWord)minfo.AllocationBase())) break;
            stackSize = stackSize.add(minfo.RegionSize());
        }
        stackBasePtr.write((WordBase)bottom.add(stackSize));
        return true;
    }
}

