/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.PosixVMSemaphoreSupport;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.pthread.PthreadConditionUtils;
import com.oracle.svm.core.posix.pthread.PthreadVMCondition;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.word.WordFactory;

public final class PthreadVMLockSupport
extends VMLockSupport {
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    PthreadVMMutex[] mutexes;
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    PthreadVMCondition[] conditions;

    @Fold
    public static PthreadVMLockSupport singleton() {
        return (PthreadVMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean initialize() {
        PthreadVMLockSupport support = PthreadVMLockSupport.singleton();
        for (PthreadVMMutex mutex : support.mutexes) {
            if (Pthread.pthread_mutex_init(mutex.getStructPointer(), (Pthread.pthread_mutexattr_t)WordFactory.nullPointer()) == 0) continue;
            return false;
        }
        for (PthreadVMCondition condition : support.conditions) {
            if (PthreadConditionUtils.initConditionWithRelativeTime(condition.getStructPointer()) == 0) continue;
            return false;
        }
        return PosixVMSemaphoreSupport.singleton().initialize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void checkResult(int result, String functionName) {
        if (result != 0) {
            PthreadVMLockSupport.fatalError(result, functionName);
        }
    }

    @Uninterruptible(reason="Error handling is interruptible.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static void fatalError(int result, String functionName) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        Log.log().string(functionName).string(" returned ").signed(result).newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    public PthreadVMMutex[] getMutexes() {
        return this.mutexes;
    }

    public PthreadVMCondition[] getConditions() {
        return this.conditions;
    }

    @Override
    public VMSemaphore[] getSemaphores() {
        return PosixVMSemaphoreSupport.singleton().getSemaphores();
    }
}

