/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_jdk_internal_misc_Signal;
import com.oracle.svm.core.posix.Util_jdk_internal_misc_Signal;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;

final class IgnoreSignalsStartupHook
implements RuntimeSupport.Hook {
    private static final CEntryPointLiteral<Signal.SignalDispatcher> NOOP_SIGNAL_HANDLER = CEntryPointLiteral.create(IgnoreSignalsStartupHook.class, (String)"noopSignalHandler", (Class[])new Class[]{Integer.TYPE});

    IgnoreSignalsStartupHook() {
    }

    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="empty signal handler, Isolate is not set up")
    static void noopSignalHandler(int sig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(boolean isFirstIsolate) {
        if (!isFirstIsolate || !SubstrateOptions.EnableSignalHandling.getValue().booleanValue()) return;
        Class<Target_jdk_internal_misc_Signal> clazz = Target_jdk_internal_misc_Signal.class;
        synchronized (Target_jdk_internal_misc_Signal.class) {
            IgnoreSignalsStartupHook.installNoopHandler(Signal.SignalEnum.SIGPIPE);
            IgnoreSignalsStartupHook.installNoopHandler(Signal.SignalEnum.SIGXFSZ);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void installNoopHandler(Signal.SignalEnum signal) {
        Signal.SignalDispatcher signalResult;
        int signum = signal.getCValue();
        if (Util_jdk_internal_misc_Signal.isCurrentDispatcher(signum, Signal.SIG_DFL()) && (signalResult = PosixUtils.installSignalHandler(signum, (Signal.SignalDispatcher)NOOP_SIGNAL_HANDLER.getFunctionPointer(), Signal.SA_RESTART())) == Signal.SIG_ERR()) {
            throw VMError.shouldNotReachHere(String.format("IgnoreSignalsStartupHook: Could not install signal: %s", new Object[]{signal}));
        }
    }
}

