/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.ChunksAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkLogging;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class Space {
    private final String name;
    private final String shortName;
    private final boolean isFromSpace;
    private final int age;
    private final ChunksAccounting accounting;
    private AlignedHeapChunk.AlignedHeader firstAlignedHeapChunk;
    private AlignedHeapChunk.AlignedHeader lastAlignedHeapChunk;
    private UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk;
    private UnalignedHeapChunk.UnalignedHeader lastUnalignedHeapChunk;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    Space(String name, String shortName, boolean isFromSpace, int age) {
        this(name, shortName, isFromSpace, age, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    Space(String name, String shortName, boolean isFromSpace, int age, ChunksAccounting parentAccounting) {
        assert (name != null) : "Space name should not be null.";
        this.name = name;
        this.shortName = shortName;
        this.isFromSpace = isFromSpace;
        this.age = age;
        this.accounting = new ChunksAccounting(parentAccounting);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getShortName() {
        return this.shortName;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isEmpty() {
        return this.getFirstAlignedHeapChunk().isNull() && this.getFirstUnalignedHeapChunk().isNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        HeapChunkProvider.freeAlignedChunkList(this.getFirstAlignedHeapChunk());
        HeapChunkProvider.freeUnalignedChunkList(this.getFirstUnalignedHeapChunk());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isEdenSpace() {
        return this.age == 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isYoungSpace() {
        return this.age <= HeapParameters.getMaxSurvivorSpaces();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isSurvivorSpace() {
        return this.age > 0 && this.age <= HeapParameters.getMaxSurvivorSpaces();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isOldSpace() {
        return this.age == HeapParameters.getMaxSurvivorSpaces() + 1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    int getAge() {
        return this.age;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    int getNextAgeForPromotion() {
        return this.age + 1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isFromSpace() {
        return this.isFromSpace;
    }

    public boolean walkObjects(ObjectVisitor visitor) {
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            if (!AlignedHeapChunk.walkObjects(aChunk, visitor)) {
                return false;
            }
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            if (!UnalignedHeapChunk.walkObjects(uChunk, visitor)) {
                return false;
            }
            uChunk = HeapChunk.getNext(uChunk);
        }
        return true;
    }

    public void logUsage(Log log, boolean logIfEmpty) {
        UnsignedWord chunkBytes = this.isEdenSpace() && !VMOperation.isGCInProgress() ? HeapImpl.getAccounting().getEdenUsedBytes() : this.getChunkBytes();
        if (logIfEmpty || chunkBytes.aboveThan(0)) {
            log.string(this.getName()).string(": ").rational(chunkBytes, 0x100000L, 2L).string("M (").rational(this.accounting.getAlignedChunkBytes(), 0x100000L, 2L).string("M in ").signed(this.accounting.getAlignedChunkCount()).string(" aligned chunks, ").rational(this.accounting.getUnalignedChunkBytes(), 0x100000L, 2L).string("M in ").signed(this.accounting.getUnalignedChunkCount()).string(" unaligned chunks)").newline();
        }
    }

    public void logChunks(Log log) {
        HeapChunkLogging.logChunks(log, this.getFirstAlignedHeapChunk(), this.shortName, this.isFromSpace);
        HeapChunkLogging.logChunks(log, this.getFirstUnalignedHeapChunk(), this.shortName, this.isFromSpace);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer allocateMemory(UnsignedWord objectSize) {
        Pointer result = (Pointer)WordFactory.nullPointer();
        AlignedHeapChunk.AlignedHeader oldChunk = this.getLastAlignedHeapChunk();
        if (oldChunk.isNonNull()) {
            result = AlignedHeapChunk.allocateMemory(oldChunk, objectSize);
        }
        if (result.isNonNull()) {
            return result;
        }
        return this.allocateInNewChunk(objectSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer allocateInNewChunk(UnsignedWord objectSize) {
        AlignedHeapChunk.AlignedHeader newChunk = this.requestAlignedHeapChunk();
        if (newChunk.isNonNull()) {
            return AlignedHeapChunk.allocateMemory(newChunk, objectSize);
        }
        return (Pointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void releaseChunks(GCImpl.ChunkReleaser chunkReleaser) {
        chunkReleaser.add(this.firstAlignedHeapChunk);
        chunkReleaser.add(this.firstUnalignedHeapChunk);
        this.firstAlignedHeapChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        this.lastAlignedHeapChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        this.firstUnalignedHeapChunk = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
        this.lastUnalignedHeapChunk = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
        this.accounting.reset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void appendAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.guaranteeOwnsThreadMutex("Trying to append an aligned heap chunk but no mutual exclusion.", true);
        }
        this.appendAlignedHeapChunkUninterruptibly(aChunk);
        this.accounting.noteAlignedHeapChunk();
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void appendAlignedHeapChunkUninterruptibly(AlignedHeapChunk.AlignedHeader aChunk) {
        AlignedHeapChunk.AlignedHeader oldLast = this.getLastAlignedHeapChunk();
        HeapChunk.setSpace(aChunk, this);
        HeapChunk.setPrevious(aChunk, oldLast);
        HeapChunk.setNext(aChunk, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        if (oldLast.isNonNull()) {
            HeapChunk.setNext(oldLast, aChunk);
        }
        this.setLastAlignedHeapChunk(aChunk);
        if (this.getFirstAlignedHeapChunk().isNull()) {
            this.setFirstAlignedHeapChunk(aChunk);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void extractAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk) {
        assert (VMOperation.isGCInProgress()) : "Should only be called by the collector.";
        this.extractAlignedHeapChunkUninterruptibly(aChunk);
        this.accounting.unnoteAlignedHeapChunk();
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void extractAlignedHeapChunkUninterruptibly(AlignedHeapChunk.AlignedHeader aChunk) {
        AlignedHeapChunk.AlignedHeader chunkNext = HeapChunk.getNext(aChunk);
        AlignedHeapChunk.AlignedHeader chunkPrev = HeapChunk.getPrevious(aChunk);
        if (chunkPrev.isNonNull()) {
            HeapChunk.setNext(chunkPrev, chunkNext);
        } else {
            this.setFirstAlignedHeapChunk(chunkNext);
        }
        if (chunkNext.isNonNull()) {
            HeapChunk.setPrevious(chunkNext, chunkPrev);
        } else {
            this.setLastAlignedHeapChunk(chunkPrev);
        }
        HeapChunk.setNext(aChunk, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        HeapChunk.setPrevious(aChunk, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        HeapChunk.setSpace(aChunk, null);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void appendUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.guaranteeOwnsThreadMutex("Trying to append an unaligned chunk but no mutual exclusion.", true);
        }
        this.appendUnalignedHeapChunkUninterruptibly(uChunk);
        this.accounting.noteUnalignedHeapChunk(uChunk);
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void appendUnalignedHeapChunkUninterruptibly(UnalignedHeapChunk.UnalignedHeader uChunk) {
        UnalignedHeapChunk.UnalignedHeader oldLast = this.getLastUnalignedHeapChunk();
        HeapChunk.setSpace(uChunk, this);
        HeapChunk.setPrevious(uChunk, oldLast);
        HeapChunk.setNext(uChunk, (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        if (oldLast.isNonNull()) {
            HeapChunk.setNext(oldLast, uChunk);
        }
        this.setLastUnalignedHeapChunk(uChunk);
        if (this.getFirstUnalignedHeapChunk().isNull()) {
            this.setFirstUnalignedHeapChunk(uChunk);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void extractUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk) {
        assert (VMOperation.isGCInProgress()) : "Trying to extract an unaligned chunk but not in a VMOperation.";
        this.extractUnalignedHeapChunkUninterruptibly(uChunk);
        this.accounting.unnoteUnalignedHeapChunk(uChunk);
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void extractUnalignedHeapChunkUninterruptibly(UnalignedHeapChunk.UnalignedHeader uChunk) {
        UnalignedHeapChunk.UnalignedHeader chunkNext = HeapChunk.getNext(uChunk);
        UnalignedHeapChunk.UnalignedHeader chunkPrev = HeapChunk.getPrevious(uChunk);
        if (chunkPrev.isNonNull()) {
            HeapChunk.setNext(chunkPrev, chunkNext);
        } else {
            this.setFirstUnalignedHeapChunk(chunkNext);
        }
        if (chunkNext.isNonNull()) {
            HeapChunk.setPrevious(chunkNext, chunkPrev);
        } else {
            this.setLastUnalignedHeapChunk(chunkPrev);
        }
        HeapChunk.setNext(uChunk, (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        HeapChunk.setPrevious(uChunk, (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        HeapChunk.setSpace(uChunk, null);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public AlignedHeapChunk.AlignedHeader getFirstAlignedHeapChunk() {
        return this.firstAlignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setFirstAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        this.firstAlignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader getLastAlignedHeapChunk() {
        return this.lastAlignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setLastAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        this.lastAlignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnalignedHeapChunk.UnalignedHeader getFirstUnalignedHeapChunk() {
        return this.firstUnalignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setFirstUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        this.firstUnalignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnalignedHeapChunk.UnalignedHeader getLastUnalignedHeapChunk() {
        return this.lastUnalignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setLastUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        this.lastUnalignedHeapChunk = chunk;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Object promoteAlignedObject(Object original, Space originalSpace) {
        assert (ObjectHeaderImpl.isAlignedObject(original));
        assert (this != originalSpace && originalSpace.isFromSpace());
        Object copy = this.copyAlignedObject(original);
        if (copy != null) {
            ObjectHeaderImpl.getObjectHeaderImpl().installForwardingPointer(original, copy);
        }
        return copy;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Object copyAlignedObject(Object originalObj) {
        Pointer copyMemory;
        Word header;
        UnsignedWord originalSize;
        assert (VMOperation.isGCInProgress());
        assert (ObjectHeaderImpl.isAlignedObject(originalObj));
        UnsignedWord copySize = originalSize = LayoutEncoding.getSizeFromObjectInlineInGC(originalObj, false);
        boolean addIdentityHashField = false;
        if (!ConfigurationValues.getObjectLayout().hasFixedIdentityHashField() && BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)ObjectHeaderImpl.hasIdentityHashFromAddressInline(header = ObjectHeader.readHeaderFromObject(originalObj)))) {
            addIdentityHashField = true;
            copySize = LayoutEncoding.getSizeFromObjectInlineInGC(originalObj, true);
        }
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)(copyMemory = this.allocateMemory(copySize)).isNull())) {
            return null;
        }
        Word originalMemory = Word.objectToUntrackedPointer((Object)originalObj);
        UnmanagedMemoryUtil.copyLongsForward((Pointer)originalMemory, copyMemory, originalSize);
        Object copy = copyMemory.toObject();
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)addIdentityHashField)) {
            int value = IdentityHashCodeSupport.computeHashCodeFromAddress(originalObj);
            int offset = LayoutEncoding.getOptionalIdentityHashOffset(copy);
            ObjectAccess.writeInt((Object)copy, (int)offset, (int)value, (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
            ObjectHeaderImpl.getObjectHeaderImpl().setIdentityHashInField(copy);
        }
        if (this.isOldSpace()) {
            AlignedHeapChunk.AlignedHeader copyChunk = AlignedHeapChunk.getEnclosingChunk(copy);
            RememberedSet.get().enableRememberedSetForObject(copyChunk, copy);
        }
        return copy;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void promoteAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk, Space originalSpace) {
        assert (this != originalSpace && originalSpace.isFromSpace());
        originalSpace.extractAlignedHeapChunk(chunk);
        this.appendAlignedHeapChunk(chunk);
        if (this.isOldSpace()) {
            if (originalSpace.isYoungSpace()) {
                RememberedSet.get().enableRememberedSetForChunk(chunk);
            } else {
                assert (originalSpace.isOldSpace());
                RememberedSet.get().clearRememberedSet(chunk);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void promoteUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk, Space originalSpace) {
        assert (this != originalSpace && originalSpace.isFromSpace());
        originalSpace.extractUnalignedHeapChunk(chunk);
        this.appendUnalignedHeapChunk(chunk);
        if (this.isOldSpace()) {
            if (originalSpace.isYoungSpace()) {
                RememberedSet.get().enableRememberedSetForChunk(chunk);
            } else {
                assert (originalSpace.isOldSpace());
                RememberedSet.get().clearRememberedSet(chunk);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private AlignedHeapChunk.AlignedHeader requestAlignedHeapChunk() {
        AlignedHeapChunk.AlignedHeader chunk;
        if (this.isYoungSpace()) {
            assert (this.isSurvivorSpace());
            chunk = HeapImpl.getHeapImpl().getYoungGeneration().requestAlignedSurvivorChunk();
        } else {
            chunk = HeapImpl.getHeapImpl().getOldGeneration().requestAlignedChunk();
        }
        if (chunk.isNonNull()) {
            this.appendAlignedHeapChunk(chunk);
        }
        return chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void absorb(Space src) {
        AlignedHeapChunk.AlignedHeader aChunk = src.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(aChunk);
            src.extractAlignedHeapChunk(aChunk);
            this.appendAlignedHeapChunk(aChunk);
            aChunk = next;
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = src.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = HeapChunk.getNext(uChunk);
            src.extractUnalignedHeapChunk(uChunk);
            this.appendUnalignedHeapChunk(uChunk);
            uChunk = next;
        }
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        boolean continueVisiting = true;
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (continueVisiting && aChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(aChunk, AlignedHeapChunk.getMemoryWalkerAccess());
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (continueVisiting && uChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(uChunk, UnalignedHeapChunk.getMemoryWalkerAccess());
            uChunk = HeapChunk.getNext(uChunk);
        }
        return continueVisiting;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getChunkBytes() {
        assert (!this.isEdenSpace() || Space.areEdenBytesCorrect()) : "eden bytes are only accurate during a GC, or at a safepoint after a TLAB flush";
        return this.getAlignedChunkBytes().add(this.accounting.getUnalignedChunkBytes());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean areEdenBytesCorrect() {
        if (VMOperation.isGCInProgress()) {
            return true;
        }
        if (VMOperation.isInProgressAtSafepoint()) {
            IsolateThread thread = VMThreads.firstThread();
            while (thread.isNonNull()) {
                ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.getTlab(thread);
                if (tlab.getAlignedChunk().isNonNull() || tlab.getUnalignedChunk().isNonNull()) {
                    return false;
                }
                thread = VMThreads.nextThread(thread);
            }
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getAlignedChunkBytes() {
        return this.accounting.getAlignedChunkBytes();
    }

    UnsignedWord computeObjectBytes() {
        assert (!this.isEdenSpace() || Space.areEdenBytesCorrect()) : "eden bytes are only accurate during a GC, or at a safepoint after a TLAB flush";
        return this.computeAlignedObjectBytes().add(this.computeUnalignedObjectBytes());
    }

    private UnsignedWord computeAlignedObjectBytes() {
        UnsignedWord result = (UnsignedWord)WordFactory.zero();
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            UnsignedWord allocatedBytes = HeapChunk.getTopOffset(aChunk).subtract(AlignedHeapChunk.getObjectsStartOffset());
            result = result.add(allocatedBytes);
            aChunk = HeapChunk.getNext(aChunk);
        }
        return result;
    }

    private UnsignedWord computeUnalignedObjectBytes() {
        UnsignedWord result = (UnsignedWord)WordFactory.zero();
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            UnsignedWord allocatedBytes = HeapChunk.getTopOffset(uChunk).subtract(UnalignedHeapChunk.getObjectStartOffset());
            result = result.add(allocatedBytes);
            uChunk = HeapChunk.getNext(uChunk);
        }
        return result;
    }
}

