/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import com.oracle.svm.hosted.meta.HostedField;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;

@NodeInfo(size=NodeSize.SIZE_1, cycles=NodeCycles.CYCLES_1)
public final class IsStaticFinalFieldInitializedNode
extends FixedWithNextNode
implements Simplifiable {
    public static final NodeClass<IsStaticFinalFieldInitializedNode> TYPE = NodeClass.create(IsStaticFinalFieldInitializedNode.class);
    private final ResolvedJavaField field;

    protected IsStaticFinalFieldInitializedNode(ResolvedJavaField field) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Boolean));
        this.field = field;
    }

    public ResolvedJavaField getField() {
        return this.field;
    }

    public void simplify(SimplifierTool tool) {
        ConstantNode replacementNode;
        if (this.field instanceof AnalysisField) {
            return;
        }
        assert (this.field instanceof HostedField);
        if (this.field.getDeclaringClass().isInitialized()) {
            replacementNode = ConstantNode.forBoolean((boolean)true, (StructuredGraph)this.graph());
        } else {
            StaticFinalFieldFoldingFeature feature = StaticFinalFieldFoldingFeature.singleton();
            Integer fieldCheckIndex = feature.fieldCheckIndexMap.get(StaticFinalFieldFoldingFeature.toAnalysisField(this.field));
            assert (fieldCheckIndex != null) : "Field must be optimizable: " + this.field;
            ConstantNode fieldInitializationStatusNode = ConstantNode.forConstant((JavaConstant)tool.getSnippetReflection().forObject((Object)feature.fieldInitializationStatus), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph());
            ConstantNode fieldCheckIndexNode = ConstantNode.forInt((int)fieldCheckIndex, (StructuredGraph)this.graph());
            replacementNode = (ValueNode)this.graph().addOrUniqueWithInputs((Node)LoadIndexedNode.create((Assumptions)this.graph().getAssumptions(), (ValueNode)fieldInitializationStatusNode, (ValueNode)fieldCheckIndexNode, null, (JavaKind)JavaKind.Boolean, (MetaAccessProvider)tool.getMetaAccess(), (ConstantReflectionProvider)tool.getConstantReflection()));
        }
        this.graph().replaceFixed((FixedWithNextNode)this, (Node)replacementNode);
    }
}

