/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.jvmstat.PerfDataSupport;
import com.oracle.svm.core.jvmstat.PerfDirectMemoryLong;
import com.oracle.svm.core.jvmstat.PerfDirectMemoryString;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfMemory;
import com.oracle.svm.core.jvmstat.PerfUnit;
import com.oracle.svm.core.jvmstat.PerfVariability;
import java.nio.ByteBuffer;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.c.type.CLongPointer;

public class PerfDataSupportImpl
implements PerfDataSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    PerfDataSupportImpl() {
    }

    @Override
    public ByteBuffer attach(int lvmid) {
        if (lvmid != 0 && (long)lvmid != ProcessProperties.getProcessID()) {
            throw new IllegalArgumentException("Attaching to the performance data of another Java virtual machine is not supported at the moment.");
        }
        PerfDataSupportImpl.waitForPerformanceDataInitialization();
        return ((PerfMemory)ImageSingletons.lookup(PerfMemory.class)).createByteBuffer();
    }

    @Override
    public void detach(ByteBuffer bb) {
    }

    @Override
    public long highResCounter() {
        PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
        return perfManager.elapsedTicks();
    }

    @Override
    public long highResFrequency() {
        return 1000000000L;
    }

    @Override
    public ByteBuffer createLong(String name, int variability, int units, long value) {
        PerfUnit unit = PerfUnit.fromInt(units);
        if (unit != PerfUnit.NONE && unit != PerfUnit.BYTES && unit != PerfUnit.TICKS && unit != PerfUnit.EVENTS && unit != PerfUnit.HERTZ) {
            throw new IllegalArgumentException("Unexpected units value: " + units);
        }
        PerfVariability var = PerfVariability.fromInt(variability);
        if (var != PerfVariability.CONSTANT && var != PerfVariability.MONOTONIC && var != PerfVariability.VARIABLE) {
            throw new IllegalArgumentException("Unexpected variability value: " + variability);
        }
        PerfDataSupportImpl.waitForPerformanceDataInitialization();
        PerfDirectMemoryLong result = new PerfDirectMemoryLong(name, unit);
        return result.allocate(var, value);
    }

    @Override
    public ByteBuffer createByteArray(String name, int variability, int units, byte[] value, int maxLength) {
        int actualMaxLength;
        PerfUnit unit = PerfUnit.fromInt(units);
        if (unit != PerfUnit.STRING) {
            throw new IllegalArgumentException("Unexpected units value: " + units);
        }
        PerfVariability var = PerfVariability.fromInt(variability);
        if (var == PerfVariability.CONSTANT) {
            actualMaxLength = value.length;
        } else if (var == PerfVariability.VARIABLE) {
            actualMaxLength = maxLength;
        } else {
            throw new IllegalArgumentException("Unexpected variability value: " + variability);
        }
        PerfDataSupportImpl.waitForPerformanceDataInitialization();
        PerfDirectMemoryString result = new PerfDirectMemoryString(name, unit);
        return result.allocate(var, value, actualMaxLength);
    }

    @Override
    public CLongPointer getLong(String name) {
        PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
        return perfManager.getLongPerfEntry(name);
    }

    @Override
    public boolean hasLong(String name) {
        PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
        return perfManager.hasLongPerfEntry(name);
    }

    private static void waitForPerformanceDataInitialization() {
        ((PerfManager)ImageSingletons.lookup(PerfManager.class)).waitForInitialization();
    }
}

