/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import java.util.concurrent.atomic.AtomicLong;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.GraalError;

public class SubstrateCompilationIdentifier
implements CompilationIdentifier {
    private static final AtomicLong uniqueIds = new AtomicLong();
    private final long id = uniqueIds.getAndIncrement();
    private final ResolvedJavaMethod method;

    public SubstrateCompilationIdentifier(ResolvedJavaMethod method) {
        this.method = method;
    }

    public SubstrateCompilationIdentifier() {
        this(null);
    }

    public final String toString() {
        return this.toString(CompilationIdentifier.Verbosity.DETAILED);
    }

    public String toString(CompilationIdentifier.Verbosity verbosity) {
        return this.buildString(new StringBuilder(), verbosity).toString();
    }

    protected StringBuilder buildString(StringBuilder sb, CompilationIdentifier.Verbosity verbosity) {
        if (this.method == null || verbosity == CompilationIdentifier.Verbosity.ID) {
            this.buildID(sb);
        } else if (verbosity == CompilationIdentifier.Verbosity.NAME) {
            this.buildName(sb);
        } else {
            GraalError.guarantee((verbosity == CompilationIdentifier.Verbosity.DETAILED ? 1 : 0) != 0, (String)"unknown verbosity: %s", (Object)verbosity);
            this.buildID(sb);
            sb.append('[');
            this.buildName(sb);
            sb.append(']');
        }
        return sb;
    }

    protected void buildName(StringBuilder sb) {
        sb.append(this.method.format("%H.%n(%p)"));
    }

    protected void buildID(StringBuilder sb) {
        sb.append("SubstrateCompilation-").append(this.id);
    }
}

