/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.IsolateSupportImpl;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.os.MemoryProtectionProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedRuntimeCodeInstaller;
import com.oracle.svm.graal.isolated.OptionValuesEncoder;
import com.oracle.svm.graal.meta.SubstrateMethod;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class IsolatedGraalUtils {
    public static CompilerIsolateThread createCompilationIsolate() {
        Isolates.CreateIsolateParameters.Builder builder = new Isolates.CreateIsolateParameters.Builder();
        long addressSpaceSize = SubstrateOptions.CompilationIsolateAddressSpaceSize.getValue();
        if (addressSpaceSize > 0L) {
            builder.reservedAddressSpaceSize((UnsignedWord)WordFactory.signed((long)addressSpaceSize));
        }
        if (MemoryProtectionProvider.isAvailable()) {
            Isolates.ProtectionDomain domain = MemoryProtectionProvider.singleton().getProtectionDomain();
            builder.setProtectionDomain(domain);
        }
        IsolatedGraalUtils.appendOptionsRelevantForCompilationIsolates(builder);
        IsolatedGraalUtils.appendOptionsExplicitlySetForCompilationIsolates(builder);
        Isolates.CreateIsolateParameters params = builder.build();
        CompilerIsolateThread isolate = (CompilerIsolateThread)IsolateSupportImpl.createIsolate(params, true);
        IsolatedGraalUtils.initializeCompilationIsolate(isolate);
        return isolate;
    }

    private static void appendOptionsRelevantForCompilationIsolates(Isolates.CreateIsolateParameters.Builder builder) {
        UnmodifiableMapCursor cur = RuntimeOptionValues.singleton().getMap().getEntries();
        while (cur.advance()) {
            RuntimeOptionKey runtimeOptionKey;
            Object object = cur.getKey();
            if (!(object instanceof RuntimeOptionKey) || !(runtimeOptionKey = (RuntimeOptionKey)object).shouldCopyToCompilationIsolate()) continue;
            IsolatedGraalUtils.appendArgument(builder, runtimeOptionKey, cur.getValue());
        }
        IsolatedGraalUtils.appendArgument(builder, SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling, false);
    }

    private static void appendOptionsExplicitlySetForCompilationIsolates(Isolates.CreateIsolateParameters.Builder builder) {
        String optionString = SubstrateOptions.CompilationIsolateOptions.getValue();
        if (optionString == null) {
            return;
        }
        int start = 0;
        int prev = 32;
        boolean withinQuotes = false;
        for (int i = 0; i < optionString.length(); ++i) {
            char c = optionString.charAt(i);
            if (!withinQuotes && prev == 39 && c != ' ') {
                throw new Isolates.IsolateException("Failed while parsing " + SubstrateOptions.CompilationIsolateOptions.getName() + ": space expected after " + optionString.substring(0, i));
            }
            if (c == '\'') {
                boolean bl = withinQuotes = !withinQuotes;
                if (withinQuotes && prev != 32) {
                    throw new Isolates.IsolateException("Failed while parsing " + SubstrateOptions.CompilationIsolateOptions.getName() + ": expected space after " + optionString.substring(0, i));
                }
                if (!withinQuotes && i > start) {
                    builder.appendArgument(optionString.substring(start, i));
                }
                start = i + 1;
            } else if (!withinQuotes && c == ' ') {
                if (i > start) {
                    builder.appendArgument(optionString.substring(start, i));
                }
                start = i + 1;
            }
            prev = c;
        }
        if (withinQuotes) {
            throw new Isolates.IsolateException("Failed while parsing " + SubstrateOptions.CompilationIsolateOptions.getName() + ": unmatched single quote.");
        }
        if (start < optionString.length()) {
            builder.appendArgument(optionString.substring(start));
        }
    }

    private static void appendArgument(Isolates.CreateIsolateParameters.Builder builder, OptionKey<?> optionKey, Object value) {
        Object optionString = "-XX:";
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            optionString = (String)optionString + (b != false ? "+" : "-");
            optionString = (String)optionString + optionKey.getName();
        } else {
            optionString = (String)optionString + optionKey.getName();
            optionString = (String)optionString + "=";
            optionString = (String)optionString + IsolatedGraalUtils.formatOptionValue(value);
        }
        builder.appendArgument((String)optionString);
    }

    private static String formatOptionValue(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.toString();
        }
        if (value instanceof String) {
            String str = (String)value;
            return str;
        }
        throw VMError.shouldNotReachHere("Unexpected option type: " + value);
    }

    private static void initializeCompilationIsolate(CompilerIsolateThread isolate) {
        byte[] encodedOptions = IsolatedGraalUtils.encodeNonNativeImageRuntimeOptionValues();
        try (PrimitiveArrayView ref = PrimitiveArrayView.createForReading(encodedOptions);){
            IsolatedGraalUtils.initializeCompilationIsolate0(isolate, ref.addressOfArrayElement(0), encodedOptions.length);
        }
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static void initializeCompilationIsolate0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread isolate, PointerBase runtimeOptions, int runtimeOptionsLength) {
        IsolatedGraalUtils.applyClientRuntimeOptionValues(runtimeOptions, runtimeOptionsLength);
        VMRuntime.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstalledCode compileInNewIsolateAndInstall(SubstrateMethod method) {
        InstalledCode installedCode;
        CompilerIsolateThread context = IsolatedGraalUtils.createCompilationIsolate();
        IsolatedCompileClient.set(new IsolatedCompileClient(context));
        try {
            ClientHandle<SubstrateInstalledCode> installedCodeHandle = IsolatedGraalUtils.compileInNewIsolateAndInstall0(context, (ClientIsolateThread)CurrentIsolate.getCurrentThread(), ImageHeapObjects.ref(method));
            Isolates.tearDownIsolate((IsolateThread)context);
            installedCode = (InstalledCode)IsolatedCompileClient.get().unhand(installedCodeHandle);
        }
        finally {
            IsolatedCompileClient.set(null);
        }
        return installedCode;
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.ResetContextWordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(epilogue=IsolatedCompileContext.ExitCompilationEpilogue.class, callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static ClientHandle<SubstrateInstalledCode> compileInNewIsolateAndInstall0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread isolate, ClientIsolateThread clientIsolate, ImageHeapRef<SubstrateMethod> methodRef) {
        IsolatedCompileContext.set(new IsolatedCompileContext(clientIsolate));
        SubstrateMethod method = ImageHeapObjects.deref(methodRef);
        DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();
        CompilationResult compilationResult = SubstrateGraalUtils.doCompile(debug, GraalSupport.getRuntimeConfig(), GraalSupport.getLIRSuites(), method);
        ClientHandle<SubstrateInstalledCode> installedCodeHandle = IsolatedRuntimeCodeInstaller.installInClientIsolate(methodRef, compilationResult, (ClientHandle)IsolatedHandles.nullHandle());
        Log.log().string("Code for " + method.format("%H.%n(%p)") + ": " + compilationResult.getTargetCodeSize() + " bytes").newline();
        return installedCodeHandle;
    }

    public static void compileInNewIsolate(SubstrateMethod method) {
        if (SubstrateOptions.shouldCompileInIsolates()) {
            CompilerIsolateThread context = IsolatedGraalUtils.createCompilationIsolate();
            IsolatedCompileClient.set(new IsolatedCompileClient(context));
            try {
                IsolatedGraalUtils.compileInNewIsolate0(context, (ClientIsolateThread)CurrentIsolate.getCurrentThread(), ImageHeapObjects.ref(method));
                Isolates.tearDownIsolate((IsolateThread)context);
            }
            finally {
                IsolatedCompileClient.set(null);
            }
        }
        try (DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();){
            SubstrateGraalUtils.compile(debug, method);
        }
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.ResetContextWordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(epilogue=IsolatedCompileContext.ExitCompilationEpilogue.class, callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static WordBase compileInNewIsolate0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread isolate, ClientIsolateThread clientIsolate, ImageHeapRef<SubstrateMethod> methodRef) {
        IsolatedCompileContext.set(new IsolatedCompileContext(clientIsolate));
        try (DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();){
            SubstrateGraalUtils.doCompile(debug, GraalSupport.getRuntimeConfig(), GraalSupport.getLIRSuites(), ImageHeapObjects.deref(methodRef));
        }
        return WordFactory.zero();
    }

    private static byte[] encodeNonNativeImageRuntimeOptionValues() {
        EconomicMap result = EconomicMap.create();
        UnmodifiableMapCursor cur = RuntimeOptionValues.singleton().getMap().getEntries();
        while (cur.advance()) {
            OptionKey optionKey = (OptionKey)cur.getKey();
            if (optionKey instanceof RuntimeOptionKey) continue;
            result.put((Object)optionKey, cur.getValue());
        }
        result.put((Object)DebugOptions.DumpPath, (Object)DebugOptions.getDumpDirectoryName((OptionValues)RuntimeOptionValues.singleton()));
        return OptionValuesEncoder.encode(result);
    }

    private static void applyClientRuntimeOptionValues(PointerBase encodedOptionsPtr, int encodedOptionsLength) {
        if (encodedOptionsPtr.isNull()) {
            return;
        }
        byte[] encodedOptions = new byte[encodedOptionsLength];
        ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)encodedOptionsPtr, (int)encodedOptionsLength);
        buffer.get(encodedOptions);
        EconomicMap<OptionKey<?>, Object> options = OptionValuesEncoder.decode(encodedOptions);
        options.replaceAll((k, v) -> OptionsParser.parseOptionValue((OptionDescriptor)k.getDescriptor(), (Object)v));
        RuntimeOptionValues.singleton().update((UnmodifiableEconomicMap)options);
    }

    public static int getNullableArrayLength(Object array) {
        return array != null ? Array.getLength(array) : -1;
    }

    private IsolatedGraalUtils() {
    }
}

