/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.windows.WindowsVMCondition;
import com.oracle.svm.core.windows.WindowsVMMutex;
import com.oracle.svm.core.windows.WindowsVMSemaphore;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;

public final class WindowsVMLockSupport
extends VMLockSupport {
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    WindowsVMMutex[] mutexes;
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    WindowsVMCondition[] conditions;
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    WindowsVMSemaphore[] semaphores;

    @Fold
    public static WindowsVMLockSupport singleton() {
        return (WindowsVMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static void initialize() {
        WindowsVMLockSupport support = WindowsVMLockSupport.singleton();
        for (WindowsVMMutex mutex : support.mutexes) {
            Process.NoTransitions.InitializeCriticalSection(mutex.getStructPointer());
        }
        for (WindowsVMCondition condition : support.conditions) {
            Process.NoTransitions.InitializeConditionVariable(condition.getStructPointer());
        }
        for (WindowsVMSemaphore semaphore : support.semaphores) {
            semaphore.init();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void checkResult(int result, String functionName) {
        if (result == 0) {
            WindowsVMLockSupport.fatalError(functionName);
        }
    }

    @Uninterruptible(reason="Error handling is interruptible.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static void fatalError(String functionName) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        int lastError = WinBase.GetLastError();
        Log.log().string(functionName).string(" failed with error ").hex(lastError).newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    @Override
    public VMMutex[] getMutexes() {
        return this.mutexes;
    }

    @Override
    public VMCondition[] getConditions() {
        return this.conditions;
    }

    @Override
    public VMSemaphore[] getSemaphores() {
        return this.semaphores;
    }
}

