/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.BaseProcessPropertiesSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.WindowsSystemPropertiesSupport;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.LibLoaderAPI;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import com.oracle.svm.core.windows.headers.WindowsLibC;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.ProcessPropertiesSupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={ProcessPropertiesSupport.class})
public class WindowsProcessPropertiesSupport
extends BaseProcessPropertiesSupport {
    public String getExecutableName() {
        return WindowsProcessPropertiesSupport.getModulePath(LibLoaderAPI.GetModuleHandleA((CCharPointer)WordFactory.nullPointer()));
    }

    public void exec(Path executable, String[] args) {
        this.exec(executable, args, null);
    }

    public void exec(Path executable, String[] args, Map<String, String> env) {
        if (!Files.isExecutable(executable)) {
            throw new RuntimeException("Path " + executable + " does not point to executable file");
        }
        ArrayList<String> cmd = new ArrayList<String>(args.length);
        cmd.add(executable.toString());
        cmd.addAll(Arrays.asList(args).subList(1, args.length));
        java.lang.Process process = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd).redirectInput(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
            if (env != null) {
                pb.environment().clear();
                pb.environment().putAll(env);
            }
            process = pb.start();
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
        while (process.isAlive()) {
            try {
                System.exit(process.waitFor());
            }
            catch (InterruptedException interruptedException) {}
        }
        System.exit(process.exitValue());
    }

    public long getProcessID() {
        return Process.NoTransitions.GetCurrentProcessId();
    }

    public long getProcessID(java.lang.Process process) {
        return WindowsUtils.getpid(process);
    }

    public String getObjectFile(String symbol) {
        try (CTypeConversion.CCharPointerHolder symbolHolder = CTypeConversion.toCString((CharSequence)symbol);){
            WinBase.HMODULE builtinHandle = LibLoaderAPI.GetModuleHandleA((CCharPointer)WordFactory.nullPointer());
            PointerBase symbolAddress = LibLoaderAPI.GetProcAddress(builtinHandle, symbolHolder.get());
            if (symbolAddress.isNonNull()) {
                String string = this.getObjectFile(symbolAddress);
                return string;
            }
        }
        return null;
    }

    public String getObjectFile(PointerBase symbolAddress) {
        WinBase.HMODULEPointer module = UnsafeStackValue.get(WinBase.HMODULEPointer.class);
        if (LibLoaderAPI.GetModuleHandleExA(LibLoaderAPI.GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS() | LibLoaderAPI.GET_MODULE_HANDLE_EX_FLAG_UNCHANGED_REFCOUNT(), (CCharPointer)symbolAddress, module) == 0) {
            return null;
        }
        return WindowsProcessPropertiesSupport.getModulePath(module.read());
    }

    private static String getModulePath(WinBase.HMODULE module) {
        WindowsLibC.WCharPointer path = UnsafeStackValue.get(260, WindowsLibC.WCharPointer.class);
        int length = LibLoaderAPI.GetModuleFileNameW(module, path, 260);
        if (length == 0 || length == 260) {
            return null;
        }
        return WindowsSystemPropertiesSupport.toJavaString(path, length);
    }

    public String setLocale(String category, String locale) {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean destroy(long processID) {
        return this.destroyForcibly(processID);
    }

    public boolean destroyForcibly(long processID) {
        WinBase.HANDLE handle = Process.NoTransitions.OpenProcess(Process.PROCESS_TERMINATE(), 0, (int)processID);
        if (handle.isNull()) {
            return false;
        }
        boolean result = Process.NoTransitions.TerminateProcess(handle, 1) != 0;
        WinBase.CloseHandle(handle);
        return result;
    }

    public boolean isAlive(long processID) {
        throw VMError.intentionallyUnimplemented();
    }

    public int waitForProcessExit(long processID) {
        throw VMError.intentionallyUnimplemented();
    }
}

