/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.bundles;

import com.oracle.svm.core.jdk.localization.bundles.StoredBundle;
import java.util.Map;
import java.util.function.Function;

public final class CompressedBundle
implements StoredBundle {
    private final byte[] content;
    private final Function<byte[], Map<String, Object>> decompressionAlgorithm;
    private Map<String, Object> extracted;

    public CompressedBundle(byte[] content, Function<byte[], Map<String, Object>> decompressionAlgorithm) {
        this.content = content;
        this.decompressionAlgorithm = decompressionAlgorithm;
    }

    @Override
    public Map<String, Object> getContent(Object bundle) {
        if (this.extracted == null) {
            this.extracted = this.decompressionAlgorithm.apply(this.content);
        }
        return this.extracted;
    }
}

