/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.Uninterruptible;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public interface CEntryPointListener {
    @Fold
    public static CEntryPointListener singleton() {
        return (CEntryPointListener)ImageSingletons.lookup(CEntryPointListener.class);
    }

    @Uninterruptible(reason="Heap base is not set up yet.")
    default public void beforeThreadAttach() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    default public void afterThreadAttach() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    default public void errorThreadAttach(int error) {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    default public void beforeThreadDetach() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    default public void afterThreadDetach() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    default public void errorThreadDetach(int error) {
    }
}

