/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.InlineBeforeAnalysisPolicyUtils;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;

public class InlineBeforeAnalysisPolicyImpl
extends InlineBeforeAnalysisPolicy {
    private final int maxInliningDepth = InlineBeforeAnalysisPolicyUtils.Options.InlineBeforeAnalysisAllowedDepth.getValue();
    private final SVMHost hostVM;
    private final InlineBeforeAnalysisPolicyUtils inliningUtils;

    public InlineBeforeAnalysisPolicyImpl(SVMHost hostVM, InlineBeforeAnalysisPolicyUtils inliningUtils) {
        super(new NodePlugin[]{new ConstantFoldLoadFieldPlugin(ParsingReason.PointsToAnalysis)});
        this.hostVM = hostVM;
        this.inliningUtils = inliningUtils;
    }

    protected boolean shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (this.inliningUtils.alwaysInlineInvoke((AnalysisMetaAccess)b.getMetaAccess(), method)) {
            return true;
        }
        if (b.getDepth() > this.maxInliningDepth) {
            return false;
        }
        if (b.recursiveInliningDepth(method) > 0) {
            return false;
        }
        return InlineBeforeAnalysisPolicyUtils.inliningAllowed(this.hostVM, b, method);
    }

    protected InlineInvokePlugin.InlineInfo createInvokeInfo(ResolvedJavaMethod method) {
        return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)method);
    }

    protected boolean needsExplicitExceptions() {
        return true;
    }

    protected boolean tryInvocationPlugins() {
        return true;
    }

    protected InlineBeforeAnalysisPolicy.AbstractPolicyScope createRootScope() {
        return null;
    }

    protected InlineBeforeAnalysisPolicy.AbstractPolicyScope openCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope outer, AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, boolean[] constArgsWithReceiver, boolean intrinsifiedMethodHandle) {
        return this.inliningUtils.createAccumulativeInlineScope((InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope)outer, metaAccess, method, constArgsWithReceiver, intrinsifiedMethodHandle);
    }

    protected boolean shouldOmitIntermediateMethodInState(ResolvedJavaMethod method) {
        return this.inliningUtils.shouldOmitIntermediateMethodInState(method);
    }

    protected FixedWithNextNode processInvokeArgs(ResolvedJavaMethod targetMethod, FixedWithNextNode insertionPoint, ValueNode[] arguments) {
        return insertionPoint;
    }
}

