/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.analysis.CustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.NativeImagePointsToAnalysis;

public class PointsToCustomTypeFieldHandler
extends CustomTypeFieldHandler {
    public PointsToCustomTypeFieldHandler(BigBang bb, AnalysisMetaAccess metaAccess) {
        super(bb, metaAccess);
    }

    @Override
    protected void injectFieldTypes(AnalysisField aField, AnalysisType ... customTypes) {
        NativeImagePointsToAnalysis analysis = (NativeImagePointsToAnalysis)this.bb;
        assert (aField.getJavaKind().isObject());
        aField.registerAsWritten((Object)"@UnknownObjectField annotated field");
        for (AnalysisType type : customTypes) {
            if (type.isPrimitive()) continue;
            AllInstantiatedTypeFlow typeFlow = type.getTypeFlow((BigBang)analysis, true);
            if (aField.isStatic()) {
                typeFlow.addUse((PointsToAnalysis)analysis, (TypeFlow)aField.getStaticFieldFlow());
                continue;
            }
            typeFlow.addUse((PointsToAnalysis)analysis, (TypeFlow)aField.getInitialInstanceFieldFlow());
            if (!type.isArray()) continue;
            AnalysisType fieldComponentType = type.getComponentType();
            aField.getInitialInstanceFieldFlow().addUse((PointsToAnalysis)analysis, (TypeFlow)aField.getInstanceFieldFlow());
            if (fieldComponentType.isPrimitive()) continue;
            ArrayElementsTypeFlow elementsFlow = type.getContextInsensitiveAnalysisObject().getArrayElementsFlow((PointsToAnalysis)analysis, true);
            fieldComponentType.getTypeFlow((BigBang)analysis, false).addUse((PointsToAnalysis)analysis, (TypeFlow)elementsFlow);
        }
    }
}

