/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.results.StrengthenGraphs;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.nodes.InlinedInvokeArgumentsNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedType;
import java.lang.reflect.AnnotatedElement;
import java.util.function.Supplier;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.SimplifierTool;

public class SubstrateStrengthenGraphs
extends StrengthenGraphs {
    public SubstrateStrengthenGraphs(PointsToAnalysis bb, Universe converter) {
        super(bb, converter);
    }

    protected AnalysisType getSingleImplementorType(AnalysisType originalType) {
        HostedType singleImplementorType = ((HostedType)this.converter.lookup((JavaType)originalType)).getSingleImplementor();
        return singleImplementorType == null ? null : singleImplementorType.getWrapped();
    }

    protected AnalysisType getStrengthenStampType(AnalysisType originalType) {
        HostedType strengthenStampType = ((HostedType)this.converter.lookup((JavaType)originalType)).getStrengthenStampType();
        return strengthenStampType == null ? null : strengthenStampType.getWrapped();
    }

    protected FixedNode createInvokeWithNullReceiverReplacement(StructuredGraph graph) {
        VMError.guarantee(SubstrateCompilationDirectives.isRuntimeCompiledMethod(graph.method()), "Creating null check deoptimize in non-runtime compiled method: %s", graph.method());
        DeoptimizeNode deopt = (DeoptimizeNode)graph.add((Node)new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.NullCheckException));
        return deopt;
    }

    protected FixedNode createUnreachable(StructuredGraph graph, CoreProviders providers, Supplier<String> message) {
        boolean insertMessage;
        FixedNode unreachableNode = (FixedNode)graph.add((Node)new LoweredDeadEndNode());
        boolean bl = insertMessage = SubstrateUtil.assertionsEnabled() && !Uninterruptible.Utils.isUninterruptible((AnnotatedElement)graph.method()) && !SubstrateCompilationDirectives.isRuntimeCompiledMethod(graph.method()) && !SubstrateCompilationDirectives.singleton().isRegisteredForDeoptTesting(graph.method());
        if (insertMessage) {
            ConstantNode messageNode = ConstantNode.forConstant((JavaConstant)providers.getConstantReflection().forString(message.get()), (MetaAccessProvider)providers.getMetaAccess(), (StructuredGraph)graph);
            ForeignCallNode foreignCallNode = (ForeignCallNode)graph.add((Node)new ForeignCallNode((ForeignCallDescriptor)SnippetRuntime.UNSUPPORTED_FEATURE, new ValueNode[]{messageNode}));
            foreignCallNode.setNext(unreachableNode);
            unreachableNode = foreignCallNode;
        }
        return unreachableNode;
    }

    protected void setInvokeProfiles(Invoke invoke, JavaTypeProfile typeProfile, JavaMethodProfile methodProfile) {
        ((SubstrateMethodCallTargetNode)invoke.callTarget()).setProfiles(typeProfile, methodProfile);
    }

    protected void setInvokeProfiles(Invoke invoke, JavaTypeProfile typeProfile, JavaMethodProfile methodProfile, JavaTypeProfile staticTypeProfile) {
        ((SubstrateMethodCallTargetNode)invoke.callTarget()).setProfiles(typeProfile, methodProfile, staticTypeProfile);
    }

    protected String getTypeName(AnalysisType type) {
        return HostedStringDeduplication.singleton().deduplicate(type.toJavaName(true), false);
    }

    protected boolean simplifyDelegate(Node n, SimplifierTool tool) {
        if (n instanceof InlinedInvokeArgumentsNode) {
            InlinedInvokeArgumentsNode nodeToRemove = (InlinedInvokeArgumentsNode)n;
            nodeToRemove.graph().removeFixed((FixedWithNextNode)nodeToRemove);
            return true;
        }
        return false;
    }
}

