/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrEventWriterAccess;
import com.oracle.svm.core.jfr.JfrGlobalMemory;
import com.oracle.svm.core.jfr.JfrMetadataTypeLibrary;
import com.oracle.svm.core.jfr.JfrMethodRepository;
import com.oracle.svm.core.jfr.JfrNativeEventSetting;
import com.oracle.svm.core.jfr.JfrOptionSet;
import com.oracle.svm.core.jfr.JfrRecorderThread;
import com.oracle.svm.core.jfr.JfrStackTraceRepository;
import com.oracle.svm.core.jfr.JfrSymbolRepository;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrThreadRepository;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.JfrTypeRepository;
import com.oracle.svm.core.jfr.JfrUnlockedChunkWriter;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_SecuritySupport;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventWriter;
import com.oracle.svm.core.jfr.logging.JfrLogging;
import com.oracle.svm.core.jfr.sampler.JfrExecutionSampler;
import com.oracle.svm.core.sampler.SamplerBufferPool;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.Configuration;
import jdk.jfr.internal.LogTag;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class SubstrateJVM {
    private final List<Configuration> knownConfigurations;
    private final JfrOptionSet options;
    private final JfrNativeEventSetting[] eventSettings;
    private final JfrSymbolRepository symbolRepo;
    private final JfrTypeRepository typeRepo;
    private final JfrThreadRepository threadRepo;
    private final JfrStackTraceRepository stackTraceRepo;
    private final JfrMethodRepository methodRepo;
    private final JfrThreadLocal threadLocal;
    private final JfrGlobalMemory globalMemory;
    private final SamplerBufferPool samplerBufferPool;
    private final JfrUnlockedChunkWriter unlockedChunkWriter;
    private final JfrRecorderThread recorderThread;
    private final JfrLogging jfrLogging;
    private boolean initialized;
    private volatile boolean recording;
    private String dumpPath;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateJVM(List<Configuration> configurations) {
        this.knownConfigurations = configurations;
        this.options = new JfrOptionSet();
        int eventCount = JfrMetadataTypeLibrary.getPlatformEventCount();
        this.eventSettings = new JfrNativeEventSetting[eventCount];
        for (int i = 0; i < this.eventSettings.length; ++i) {
            this.eventSettings[i] = new JfrNativeEventSetting();
        }
        this.stackTraceRepo = new JfrStackTraceRepository();
        this.symbolRepo = new JfrSymbolRepository();
        this.typeRepo = new JfrTypeRepository();
        this.threadRepo = new JfrThreadRepository();
        this.methodRepo = new JfrMethodRepository();
        this.threadLocal = new JfrThreadLocal();
        this.globalMemory = new JfrGlobalMemory();
        this.samplerBufferPool = new SamplerBufferPool();
        this.unlockedChunkWriter = new JfrChunkWriter(this.globalMemory, this.stackTraceRepo, this.methodRepo, this.typeRepo, this.symbolRepo, this.threadRepo);
        this.recorderThread = new JfrRecorderThread(this.globalMemory, this.unlockedChunkWriter);
        this.jfrLogging = new JfrLogging();
        this.initialized = false;
        this.recording = false;
    }

    @Fold
    public static SubstrateJVM get() {
        return (SubstrateJVM)ImageSingletons.lookup(SubstrateJVM.class);
    }

    @Fold
    public static List<Configuration> getKnownConfigurations() {
        return SubstrateJVM.get().knownConfigurations;
    }

    @Fold
    public static JfrGlobalMemory getGlobalMemory() {
        return SubstrateJVM.get().globalMemory;
    }

    @Fold
    public static JfrRecorderThread getRecorderThread() {
        return SubstrateJVM.get().recorderThread;
    }

    @Fold
    public static JfrThreadLocal getThreadLocal() {
        return SubstrateJVM.get().threadLocal;
    }

    @Fold
    public static SamplerBufferPool getSamplerBufferPool() {
        return SubstrateJVM.get().samplerBufferPool;
    }

    @Fold
    public static JfrUnlockedChunkWriter getChunkWriter() {
        return SubstrateJVM.get().unlockedChunkWriter;
    }

    @Fold
    public static JfrTypeRepository getTypeRepository() {
        return SubstrateJVM.get().typeRepo;
    }

    @Fold
    public static JfrSymbolRepository getSymbolRepository() {
        return SubstrateJVM.get().symbolRepo;
    }

    @Fold
    public static JfrThreadRepository getThreadRepo() {
        return SubstrateJVM.get().threadRepo;
    }

    @Fold
    public static JfrMethodRepository getMethodRepo() {
        return SubstrateJVM.get().methodRepo;
    }

    @Fold
    public static JfrStackTraceRepository getStackTraceRepo() {
        return SubstrateJVM.get().stackTraceRepo;
    }

    @Fold
    public static JfrLogging getJfrLogging() {
        return SubstrateJVM.get().jfrLogging;
    }

    public static Object getHandler(Class<? extends Event> eventClass) {
        try {
            Field f = eventClass.getDeclaredField("eventHandler");
            f.setAccessible(true);
            return f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new InternalError("Could not access event handler");
        }
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    protected boolean isRecording() {
        return this.recording;
    }

    public boolean createJFR(boolean simulateFailure) {
        if (simulateFailure) {
            throw new IllegalStateException("Unable to start JFR");
        }
        if (this.initialized) {
            throw new IllegalStateException("JFR was already started before");
        }
        this.options.validateAndAdjustMemoryOptions();
        JfrTicks.initialize();
        this.threadLocal.initialize(this.options.threadBufferSize.getValue());
        this.globalMemory.initialize(this.options.globalBufferSize.getValue(), this.options.globalBufferCount.getValue());
        this.unlockedChunkWriter.initialize(this.options.maxChunkSize.getValue());
        this.recorderThread.start();
        this.initialized = true;
        return true;
    }

    public boolean destroyJFR() {
        assert (!this.recording) : "must already have been stopped";
        if (!this.initialized) {
            return false;
        }
        this.recorderThread.shutdown();
        JfrTeardownOperation vmOp = new JfrTeardownOperation();
        vmOp.enqueue();
        try {
            this.recorderThread.join();
        }
        catch (InterruptedException e) {
            throw VMError.shouldNotReachHere(e);
        }
        return true;
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    public long getStackTraceId(long eventTypeId, int skipCount) {
        if (this.isStackTraceEnabled(eventTypeId)) {
            return this.getStackTraceId(skipCount);
        }
        return 0L;
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    public long getStackTraceId(int skipCount) {
        if (this.isRecording()) {
            return this.stackTraceRepo.getStackTraceId(skipCount);
        }
        return 0L;
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    public long getStackTraceId(JfrEvent eventType, int skipCount) {
        return this.getStackTraceId(eventType.getId(), skipCount);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getThreadId(Thread thread) {
        if (HasJfrSupport.get()) {
            return JavaThreads.getThreadId(thread);
        }
        return 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getCurrentThreadId() {
        if (HasJfrSupport.get()) {
            return JavaThreads.getCurrentThreadId();
        }
        return 0L;
    }

    public void storeMetadataDescriptor(byte[] bytes) {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            chunkWriter.setMetadata(bytes);
        }
        finally {
            chunkWriter.unlock();
        }
    }

    public void beginRecording() {
        if (this.recording) {
            return;
        }
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            chunkWriter.maybeOpenFile();
        }
        finally {
            chunkWriter.unlock();
        }
        JfrBeginRecordingOperation vmOp = new JfrBeginRecordingOperation();
        vmOp.enqueue();
    }

    public void endRecording() {
        if (!this.recording) {
            return;
        }
        JfrEndRecordingOperation vmOp = new JfrEndRecordingOperation();
        vmOp.enqueue();
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    public long getClassId(Class<?> clazz) {
        if (this.isRecording()) {
            return this.typeRepo.getClassId(clazz);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutput(String file) {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            if (this.recording) {
                boolean existingFile = chunkWriter.hasOpenFile();
                if (existingFile) {
                    chunkWriter.closeFile();
                }
                if (file != null) {
                    chunkWriter.openFile(file);
                    if (!existingFile) {
                        this.recorderThread.signal();
                    }
                }
            } else {
                chunkWriter.setFilename(file);
            }
        }
        finally {
            chunkWriter.unlock();
        }
    }

    public void setFileNotification(long delta) {
        this.options.maxChunkSize.setUserValue(delta);
    }

    public void setGlobalBufferCount(long count) {
        this.options.globalBufferCount.setUserValue(count);
    }

    public void setGlobalBufferSize(long size) {
        this.options.globalBufferSize.setUserValue(size);
    }

    public void setMemorySize(long size) {
        this.options.memorySize.setUserValue(size);
    }

    public void setMethodSamplingInterval(long type, long intervalMillis) {
        if (type != JfrEvent.ExecutionSample.getId()) {
            return;
        }
        JfrExecutionSampler.singleton().setIntervalMillis(intervalMillis);
        if (intervalMillis > 0L) {
            this.setStackTraceEnabled(type, true);
            this.setEnabled(type, true);
        }
        this.updateSampler();
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.")
    private void updateSampler() {
        if (this.recording) {
            SubstrateJVM.updateSampler0();
        }
    }

    @Uninterruptible(reason="The executed VM operation rechecks if JFR recording is active.", calleeMustBe=false)
    private static void updateSampler0() {
        JfrExecutionSampler.singleton().update();
    }

    public void setSampleThreads(boolean sampleThreads) {
        this.setEnabled(JfrEvent.ExecutionSample.getId(), sampleThreads);
        this.setEnabled(JfrEvent.NativeMethodSample.getId(), sampleThreads);
    }

    public void setCompressedIntegers(boolean compressed) {
        if (!compressed) {
            throw new IllegalStateException("JFR currently only supports compressed integers.");
        }
    }

    public void setStackDepth(int depth) {
        this.stackTraceRepo.setStackTraceDepth(depth);
    }

    public void setStackTraceEnabled(long eventTypeId, boolean enabled) {
        this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].setStackTrace(enabled);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isStackTraceEnabled(long eventTypeId) {
        assert ((long)((int)eventTypeId) == eventTypeId);
        return this.eventSettings[(int)eventTypeId].hasStackTrace();
    }

    public void setThreadBufferSize(long size) {
        this.options.threadBufferSize.setUserValue(size);
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public boolean flush(Target_jdk_jfr_internal_event_EventWriter writer, int uncommittedSize, int requestedSize) {
        assert (writer != null);
        assert (uncommittedSize >= 0);
        JfrBuffer oldBuffer = this.threadLocal.getJavaBuffer();
        assert (oldBuffer.isNonNull()) : "Java EventWriter should not be used otherwise";
        JfrBuffer newBuffer = JfrThreadLocal.flushToGlobalMemory(oldBuffer, WordFactory.unsigned((int)uncommittedSize), requestedSize);
        if (newBuffer.isNull()) {
            JfrEventWriterAccess.update(writer, oldBuffer, 0, false);
        } else {
            JfrEventWriterAccess.update(writer, newBuffer, uncommittedSize, true);
        }
        return false;
    }

    public void flush() {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            boolean existingFile;
            if (this.recording && (existingFile = chunkWriter.hasOpenFile())) {
                chunkWriter.flush();
            }
        }
        finally {
            chunkWriter.unlock();
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.")
    public long commit(long nextPosition) {
        assert (nextPosition != 0L) : "invariant";
        JfrBuffer current = this.threadLocal.getJavaBuffer();
        assert (current.isNonNull()) : "invariant";
        Pointer next = (Pointer)WordFactory.pointer((long)nextPosition);
        assert (next.aboveOrEqual((UnsignedWord)current.getCommittedPos())) : "invariant";
        assert (next.belowOrEqual((UnsignedWord)JfrBufferAccess.getDataEnd(current))) : "invariant";
        if (JfrThreadLocal.isNotified()) {
            JfrThreadLocal.clearNotification();
            return current.getCommittedPos().rawValue();
        }
        current.setCommittedPos(next);
        return nextPosition;
    }

    public void markChunkFinal() {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            boolean existingFile;
            if (this.recording && (existingFile = chunkWriter.hasOpenFile())) {
                chunkWriter.markChunkFinal();
            }
        }
        finally {
            chunkWriter.unlock();
        }
    }

    public void setRepositoryLocation(String dirText) {
    }

    public void setDumpPath(String dumpPathText) {
        this.dumpPath = dumpPathText;
    }

    public String getDumpPath() {
        if (this.dumpPath == null) {
            this.dumpPath = Target_jdk_jfr_internal_SecuritySupport.getPathInProperty("user.home", null).toString();
        }
        return this.dumpPath;
    }

    public void abort(String errorMsg) {
        throw VMError.shouldNotReachHere(errorMsg);
    }

    public boolean shouldRotateDisk() {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            boolean bl = chunkWriter.shouldRotateDisk();
            return bl;
        }
        finally {
            chunkWriter.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChunkStartNanos() {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            long l = chunkWriter.getChunkStartNanos();
            return l;
        }
        finally {
            chunkWriter.unlock();
        }
    }

    public void log(int tagSetId, int level, String message) {
        this.jfrLogging.log(tagSetId, level, message);
    }

    public void logEvent(int level, String[] lines, boolean system) {
        this.jfrLogging.logEvent(level, lines, system);
    }

    public void subscribeLogLevel(LogTag lt, int tagSetId) {
    }

    public Target_jdk_jfr_internal_event_EventWriter getEventWriter() {
        return JfrThreadLocal.getEventWriter();
    }

    public Target_jdk_jfr_internal_event_EventWriter newEventWriter() {
        return this.threadLocal.newEventWriter();
    }

    public void setEnabled(long eventTypeId, boolean newValue) {
        boolean oldValue = this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].isEnabled();
        if (newValue != oldValue) {
            this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].setEnabled(newValue);
            if (eventTypeId == JfrEvent.ExecutionSample.getId()) {
                this.updateSampler();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isEnabled(JfrEvent event) {
        return this.eventSettings[(int)event.getId()].isEnabled();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setLarge(JfrEvent event, boolean large) {
        this.eventSettings[(int)event.getId()].setLarge(large);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isLarge(JfrEvent event) {
        return this.eventSettings[(int)event.getId()].isLarge();
    }

    public boolean setThreshold(long eventTypeId, long ticks) {
        this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].setThresholdTicks(ticks);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getThresholdTicks(JfrEvent event) {
        return this.eventSettings[(int)event.getId()].getThresholdTicks();
    }

    public boolean setCutoff(long eventTypeId, long cutoffTicks) {
        this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].setCutoffTicks(cutoffTicks);
        return true;
    }

    public boolean setConfiguration(Class<? extends Event> eventClass, Object configuration) {
        DynamicHub.fromClass(eventClass).setJrfEventConfiguration(configuration);
        return true;
    }

    public Object getConfiguration(Class<? extends Event> eventClass) {
        return DynamicHub.fromClass(eventClass).getJfrEventConfiguration();
    }

    public void setExcluded(Thread thread, boolean excluded) {
        JfrThreadLocal.setExcluded(thread, excluded);
    }

    public boolean isExcluded(Thread thread) {
        if (!thread.equals(Thread.currentThread())) {
            return false;
        }
        return this.isCurrentThreadExcluded();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isCurrentThreadExcluded() {
        return JfrThreadLocal.isCurrentThreadExcluded();
    }

    private class JfrTeardownOperation
    extends JavaVMOperation {
        JfrTeardownOperation() {
            super(VMOperationInfos.get(JfrTeardownOperation.class, "JFR teardown", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            if (!SubstrateJVM.this.initialized) {
                return;
            }
            SubstrateJVM.this.globalMemory.teardown();
            SubstrateJVM.this.symbolRepo.teardown();
            SubstrateJVM.this.threadRepo.teardown();
            SubstrateJVM.this.stackTraceRepo.teardown();
            SubstrateJVM.this.methodRepo.teardown();
            SubstrateJVM.this.typeRepo.teardown();
            SubstrateJVM.this.initialized = false;
        }
    }

    private static class JfrBeginRecordingOperation
    extends JavaVMOperation {
        JfrBeginRecordingOperation() {
            super(VMOperationInfos.get(JfrBeginRecordingOperation.class, "JFR begin recording", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            SubstrateJVM.get().recording = true;
            SubstrateJVM.getThreadRepo().registerRunningThreads();
            JfrExecutionSampler.singleton().update();
        }
    }

    private static class JfrEndRecordingOperation
    extends JavaVMOperation {
        JfrEndRecordingOperation() {
            super(VMOperationInfos.get(JfrEndRecordingOperation.class, "JFR end recording", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            SubstrateJVM.get().recording = false;
            JfrExecutionSampler.singleton().update();
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                JfrThreadLocal.stopRecording(isolateThread, false);
                isolateThread = VMThreads.nextThread(isolateThread);
            }
            SubstrateJVM.getThreadLocal().teardown();
            SubstrateJVM.getSamplerBufferPool().teardown();
            SubstrateJVM.getGlobalMemory().clear();
        }
    }
}

