/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CInterfaceReadNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.VaListInitializationNode;
import com.oracle.svm.core.graal.nodes.VaListNextArgNode;
import com.oracle.svm.core.jni.CallVariant;
import com.oracle.svm.core.jni.JNIJavaCallVariantWrapperHolder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.EntryPointCallStubMethod;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.hosted.jni.JNIGraphKit;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.Platform;
import org.graalvm.word.LocationIdentity;

public class JNIJavaCallVariantWrapperMethod
extends EntryPointCallStubMethod {
    private final Signature callWrapperSignature;
    private final CallVariant callVariant;
    private final boolean nonVirtual;

    public JNIJavaCallVariantWrapperMethod(SimpleSignature callWrapperSignature, CallVariant callVariant, boolean nonVirtual, MetaAccessProvider originalMetaAccess, WordTypes wordTypes) {
        super(JNIJavaCallVariantWrapperMethod.createName(callWrapperSignature, callVariant, nonVirtual), originalMetaAccess.lookupJavaType(JNIJavaCallVariantWrapperHolder.class), JNIJavaCallVariantWrapperMethod.createSignature(callWrapperSignature, callVariant, nonVirtual, originalMetaAccess, wordTypes), JNIJavaCallVariantWrapperHolder.getConstantPool(originalMetaAccess));
        this.callWrapperSignature = callWrapperSignature;
        this.callVariant = callVariant;
        this.nonVirtual = nonVirtual;
    }

    private static String createName(SimpleSignature targetSignature, CallVariant callVariant, boolean nonVirtual) {
        return "invoke" + targetSignature.getIdentifier() + "_" + callVariant.name() + (nonVirtual ? "_Nonvirtual" : "");
    }

    private static Signature createSignature(Signature callWrapperSignature, CallVariant callVariant, boolean nonVirtual, MetaAccessProvider originalMetaAccess, WordTypes wordTypes) {
        JavaKind wordKind = wordTypes.getWordKind();
        ArrayList<JavaKind> args = new ArrayList<JavaKind>();
        args.add(wordKind);
        args.add(wordKind);
        if (nonVirtual) {
            args.add(wordKind);
        }
        args.add(wordKind);
        if (callVariant == CallVariant.VARARGS) {
            int count = callWrapperSignature.getParameterCount(false);
            for (int i = 3; i < count; ++i) {
                JavaKind kind = callWrapperSignature.getParameterKind(i);
                if (kind.isObject()) {
                    args.add(wordKind);
                    continue;
                }
                if (Platform.includedIn(Platform.RISCV64.class) && (kind == JavaKind.Float || kind == JavaKind.Double)) {
                    args.add(JavaKind.Long);
                    continue;
                }
                if (kind == JavaKind.Float) {
                    args.add(JavaKind.Double);
                    continue;
                }
                args.add(kind.getStackKind());
            }
        } else if (callVariant == CallVariant.ARRAY) {
            args.add(wordKind);
        } else if (callVariant == CallVariant.VA_LIST) {
            args.add(wordKind);
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput((Object)callVariant);
        }
        JavaKind returnType = callWrapperSignature.getReturnKind();
        if (returnType.isObject()) {
            returnType = wordKind;
        }
        return SimpleSignature.fromKinds((JavaKind[])args.toArray(JavaKind[]::new), returnType, originalMetaAccess);
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method, purpose);
        AnalysisMetaAccess aMetaAccess = (AnalysisMetaAccess)(metaAccess instanceof AnalysisMetaAccess ? metaAccess : metaAccess.getWrapped());
        WrappedSignature invokeSignature = aMetaAccess.getUniverse().lookup(this.callWrapperSignature, this.getDeclaringClass());
        if (metaAccess instanceof HostedMetaAccess) {
            invokeSignature = new WrappedSignature(metaAccess.getUniverse(), (Signature)invokeSignature, this.getDeclaringClass());
        }
        JavaKind wordKind = providers.getWordTypes().getWordKind();
        int slotIndex = 0;
        ValueNode env = kit.loadLocal(slotIndex, wordKind);
        ValueNode receiverOrClassHandle = kit.loadLocal(slotIndex += wordKind.getSlotCount(), wordKind);
        slotIndex += wordKind.getSlotCount();
        if (this.nonVirtual) {
            slotIndex += wordKind.getSlotCount();
        }
        ValueNode methodId = kit.loadLocal(slotIndex, wordKind);
        slotIndex += wordKind.getSlotCount();
        kit.append((Node)CEntryPointEnterNode.enter(env));
        InvokeWithExceptionNode callAddress = kit.getJavaCallWrapperAddressFromMethodId(methodId);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(receiverOrClassHandle);
        args.add(methodId);
        args.add(kit.createInt(this.nonVirtual ? 1 : 0));
        args.addAll(this.loadArguments(kit, providers, (Signature)invokeSignature, args.size(), slotIndex));
        InvokeWithExceptionNode formerPendingException = kit.getAndClearPendingException();
        StampPair returnStamp = StampFactory.forDeclaredType((Assumptions)kit.getAssumptions(), (JavaType)invokeSignature.getReturnType(null), (boolean)false);
        IndirectCallTargetNode callTarget = new IndirectCallTargetNode((ValueNode)callAddress, (ValueNode[])args.toArray(ValueNode[]::new), returnStamp, invokeSignature.toParameterTypes(null), null, (CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), CallTargetNode.InvokeKind.Static);
        int invokeBci = kit.bci();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException((CallTargetNode)callTarget, kit.getFrameState(), invokeBci);
        kit.noExceptionPart();
        kit.setPendingException((ValueNode)formerPendingException);
        kit.exceptionPart();
        kit.setPendingException((ValueNode)kit.exceptionObject());
        AbstractMergeNode invokeMerge = kit.endInvokeWithException();
        ValueNode returnValue = null;
        JavaKind returnKind = JavaKind.Void;
        if (invoke.getStackKind() == JavaKind.Void) {
            invokeMerge.setStateAfter(kit.getFrameState().create(invokeBci, (StateSplit)invokeMerge));
        } else {
            FloatingNode exceptionValue = kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)invoke.getStackKind()));
            ValueNode[] inputs = new ValueNode[]{invoke, exceptionValue};
            returnValue = (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(invoke.stamp(NodeView.DEFAULT), invokeMerge, inputs));
            returnKind = returnValue.getStackKind();
            kit.getFrameState().push(returnKind, returnValue);
            invokeMerge.setStateAfter(kit.getFrameState().create(invokeBci, (StateSplit)invokeMerge));
            kit.getFrameState().pop(returnKind);
        }
        CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave);
        kit.append((Node)leave);
        kit.createReturn(returnValue, returnKind);
        return kit.finalizeGraph();
    }

    private List<ValueNode> loadArguments(JNIGraphKit kit, HostedProviders providers, Signature invokeSignature, int firstParamIndex, int firstSlotIndex) {
        JavaKind wordKind = providers.getWordTypes().getWordKind();
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        int slotIndex = firstSlotIndex;
        int count = invokeSignature.getParameterCount(false);
        if (this.callVariant == CallVariant.ARRAY || Platform.includedIn(Platform.DARWIN_AARCH64.class) && (this.callVariant == CallVariant.VARARGS || this.callVariant == CallVariant.VA_LIST) || Platform.includedIn(Platform.WINDOWS.class) && this.callVariant == CallVariant.VA_LIST) {
            ValueNode array = this.callVariant == CallVariant.VARARGS ? (ValueNode)kit.append((Node)new ReadCallerStackPointerNode()) : kit.loadLocal(slotIndex, wordKind);
            for (int i = firstParamIndex; i < count; ++i) {
                JavaKind kind = invokeSignature.getParameterKind(i);
                assert (kind == kind.getStackKind()) : "sub-int conversions and bit masking must happen in JNIJavaCallWrapperMethod";
                JavaKind readKind = kind;
                if (kind == JavaKind.Float && (this.callVariant == CallVariant.VARARGS || this.callVariant == CallVariant.VA_LIST)) {
                    readKind = JavaKind.Double;
                } else if (kind.isObject()) {
                    readKind = wordKind;
                }
                int offset = (i - firstParamIndex) * wordKind.getByteCount();
                ConstantNode offsetConstant = kit.createConstant((Constant)JavaConstant.forIntegerKind((JavaKind)wordKind, (long)offset), wordKind);
                OffsetAddressNode address = (OffsetAddressNode)kit.unique((FloatingNode)new OffsetAddressNode(array, (ValueNode)offsetConstant));
                Stamp readStamp = StampFactory.forKind((JavaKind)readKind);
                ValueNode value = (ValueNode)kit.append((Node)new CInterfaceReadNode((AddressNode)address, LocationIdentity.any(), readStamp, BarrierType.NONE, MemoryOrderMode.PLAIN, "args[" + i + "]"));
                if (kind == JavaKind.Float && readKind == JavaKind.Double) {
                    value = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.D2F, value));
                }
                args.add(value);
            }
        } else if (this.callVariant == CallVariant.VARARGS) {
            for (int i = firstParamIndex; i < count; ++i) {
                JavaKind kind = invokeSignature.getParameterKind(i);
                assert (kind == kind.getStackKind()) : "sub-int conversions and bit masking must happen in JNIJavaCallWrapperMethod";
                JavaKind loadKind = kind;
                if (Platform.includedIn(Platform.RISCV64.class) && (kind == JavaKind.Double || kind == JavaKind.Float)) {
                    loadKind = JavaKind.Long;
                } else if (loadKind == JavaKind.Float) {
                    loadKind = JavaKind.Double;
                }
                ValueNode value = kit.loadLocal(slotIndex, loadKind);
                if (Platform.includedIn(Platform.RISCV64.class) && (kind == JavaKind.Double || kind == JavaKind.Float)) {
                    value = kit.unique((FloatingNode)new ReinterpretNode(JavaKind.Double, value));
                }
                if (kind == JavaKind.Float) {
                    value = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.D2F, value));
                }
                args.add(value);
                slotIndex += loadKind.getSlotCount();
            }
        } else if (this.callVariant == CallVariant.VA_LIST) {
            ValueNode vaList = kit.loadLocal(slotIndex, wordKind);
            FixedWithNextNode vaListInitialized = (FixedWithNextNode)kit.append((Node)new VaListInitializationNode(vaList));
            for (int i = firstParamIndex; i < count; ++i) {
                JavaKind kind = invokeSignature.getParameterKind(i);
                if (kind.isObject()) {
                    kind = wordKind;
                }
                assert (kind == kind.getStackKind()) : "sub-int conversions and bit masking must happen in JNIJavaCallWrapperMethod";
                ValueNode value = (ValueNode)kit.append((Node)new VaListNextArgNode(kind, (ValueNode)vaListInitialized));
                args.add(value);
            }
        } else {
            throw VMError.unsupportedFeature("Call variant: " + this.callVariant);
        }
        return args;
    }
}

