/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.posix.headers.darwin.DarwinVirtualMemory;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={StackOverflowCheck.OSSupport.class})
final class DarwinStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    DarwinStackOverflowSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackBase() {
        WordPointer stackBasePtr = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer stackEndPtr = (WordPointer)StackValue.get(WordPointer.class);
        this.lookupStack(stackBasePtr, stackEndPtr, (UnsignedWord)WordFactory.zero());
        return (UnsignedWord)stackBasePtr.read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd() {
        return this.lookupStackEnd((UnsignedWord)WordFactory.zero());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isProtected(int prot) {
        return (prot & (DarwinVirtualMemory.VM_PROT_READ() | DarwinVirtualMemory.VM_PROT_WRITE())) == 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord vmComputeStackGuardSize(UnsignedWord stackend) {
        UnsignedWord guardsize = (UnsignedWord)WordFactory.zero();
        WordPointer address = (WordPointer)StackValue.get(WordPointer.class);
        address.write((WordBase)stackend);
        WordPointer size = (WordPointer)StackValue.get(WordPointer.class);
        size.write(WordFactory.zero());
        DarwinVirtualMemory.vm_region_basic_info_data_64_t info = (DarwinVirtualMemory.vm_region_basic_info_data_64_t)StackValue.get(DarwinVirtualMemory.vm_region_basic_info_data_64_t.class);
        WordPointer task = DarwinVirtualMemory.mach_task_self();
        do {
            WordPointer dummyobject = (WordPointer)StackValue.get(WordPointer.class);
            CIntPointer count = (CIntPointer)StackValue.get(CIntPointer.class);
            count.write(DarwinVirtualMemory.VM_REGION_SUBMAP_INFO_COUNT_64());
            int machVMRegion = DarwinVirtualMemory.mach_vm_region(task, address, size, DarwinVirtualMemory.VM_REGION_BASIC_INFO_64(), info, count, dummyobject);
            if (machVMRegion != 0) {
                throw VMError.shouldNotReachHereUnexpectedInput(machVMRegion);
            }
            if (DarwinStackOverflowSupport.isProtected(info.protection())) {
                guardsize = guardsize.add((UnsignedWord)size.read());
            }
            UnsignedWord currentAddress = (UnsignedWord)address.read();
            address.write((WordBase)currentAddress.add((UnsignedWord)size.read()));
        } while (DarwinStackOverflowSupport.isProtected(info.protection()));
        return guardsize;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd(UnsignedWord requestedStackSize) {
        WordPointer stackBasePtr = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer stackEndPtr = (WordPointer)StackValue.get(WordPointer.class);
        this.lookupStack(stackBasePtr, stackEndPtr, requestedStackSize);
        return (UnsignedWord)stackEndPtr.read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void lookupStack(WordPointer stackBasePtr, WordPointer stackEndPtr, UnsignedWord requestedStackSize) {
        Pthread.pthread_t self = Pthread.pthread_self();
        Pointer stackaddr = DarwinPthread.pthread_get_stackaddr_np(self);
        UnsignedWord stacksize = DarwinPthread.pthread_get_stacksize_np(self);
        stackBasePtr.write((WordBase)stackaddr);
        UnsignedWord guardsize = DarwinStackOverflowSupport.vmComputeStackGuardSize(stackaddr.subtract(stacksize));
        VMError.guarantee(guardsize.belowThan(102400));
        VMError.guarantee(stacksize.aboveThan(guardsize));
        stacksize = stacksize.subtract(guardsize);
        stackEndPtr.write((WordBase)stackaddr.subtract(stacksize));
        if (requestedStackSize.notEqual((UnsignedWord)WordFactory.zero()) && stacksize.aboveThan(requestedStackSize)) {
            stackEndPtr.write((WordBase)stackaddr.subtract(requestedStackSize));
        }
    }
}

