/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import java.util.EnumSet;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public interface CommittedMemoryProvider {
    public static final UnsignedWord UNALIGNED = WordFactory.unsigned((int)1);

    @Fold
    public static CommittedMemoryProvider get() {
        return (CommittedMemoryProvider)ImageSingletons.lookup(CommittedMemoryProvider.class);
    }

    @Fold
    public boolean guaranteesHeapPreferredAddressSpaceAlignment();

    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer var1, CEntryPointCreateIsolateParameters var2);

    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    default public UnsignedWord getGranularity() {
        return VirtualMemoryProvider.get().getGranularity();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateAlignedChunk(UnsignedWord var1, UnsignedWord var2);

    public Pointer allocateUnalignedChunk(UnsignedWord var1);

    public Pointer allocateExecutableMemory(UnsignedWord var1, UnsignedWord var2);

    public boolean areUnalignedChunksZeroed();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase var1, UnsignedWord var2, UnsignedWord var3);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase var1, UnsignedWord var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeExecutableMemory(PointerBase var1, UnsignedWord var2, UnsignedWord var3);

    default public void beforeGarbageCollection() {
    }

    default public void afterGarbageCollection() {
    }

    public int protect(PointerBase var1, UnsignedWord var2, EnumSet<Access> var3);

    public static enum Access {
        READ,
        WRITE,
        EXECUTE;

    }
}

