/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import org.graalvm.nativeimage.StackValue;

public class ThreadSleepEventJDK17 {
    private static final JfrEvent ThreadSleep = JfrEvent.create("jdk.ThreadSleep", true);

    public static void emit(long time, long startTicks) {
        if (HasJfrSupport.get()) {
            ThreadSleepEventJDK17.emit0(time, startTicks);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emit0(long time, long startTicks) {
        long duration = JfrTicks.duration(startTicks);
        if (ThreadSleep.shouldEmit(duration)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, ThreadSleep);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, duration);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getStackTraceId(ThreadSleep, 0));
            JfrNativeEventWriter.putLong(data, time);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

