/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ClassLoaderSupport {
    private final ConcurrentMap<ClassLoader, ConcurrentHashMap<String, Package>> registeredPackages = new ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, Package>>();
    private static final Method packageGetPackageInfo = ReflectionUtil.lookupMethod(Package.class, (String)"getPackageInfo", (Class[])new Class[0]);

    private static ClassLoaderSupport singleton() {
        return (ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class);
    }

    ClassLoaderSupport() {
    }

    public static ConcurrentMap<String, Package> registerPackage(ClassLoader classLoader, String packageName, Package packageValue) {
        assert (classLoader != null);
        assert (packageName != null);
        assert (packageValue != null);
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Packages should be collected and registered during analysis.");
        try {
            packageGetPackageInfo.invoke((Object)packageValue, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
        ConcurrentHashMap loaderPackages = ClassLoaderSupport.singleton().registeredPackages.computeIfAbsent(classLoader, k -> new ConcurrentHashMap());
        Package previous = loaderPackages.putIfAbsent(packageName, packageValue);
        if (previous == null) {
            return loaderPackages;
        }
        return null;
    }

    public static ConcurrentHashMap<String, Package> getRegisteredPackages(ClassLoader classLoader) {
        VMError.guarantee(BuildPhaseProvider.isAnalysisFinished(), "Packages are stable only after analysis.");
        return (ConcurrentHashMap)ClassLoaderSupport.singleton().registeredPackages.get(classLoader);
    }
}

