/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class HeapParameters {
    private static final UnsignedWord producedHeapChunkZapInt;
    private static final UnsignedWord producedHeapChunkZapWord;
    private static final UnsignedWord consumedHeapChunkZapInt;
    private static final UnsignedWord consumedHeapChunkZapWord;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static void initialize() {
        long alignedChunkSize = HeapParameters.getAlignedHeapChunkSize().rawValue();
        if (!SubstrateUtil.isPowerOf2(alignedChunkSize)) {
            throw UserError.abort("AlignedHeapChunkSize (%d) should be a power of 2.", alignedChunkSize);
        }
        long maxLargeArrayThreshold = alignedChunkSize - RememberedSet.get().getHeaderSizeOfAlignedChunk().rawValue() + 1L;
        if (SerialAndEpsilonGCOptions.AlignedHeapChunkSize.hasBeenSet() && !SerialAndEpsilonGCOptions.LargeArrayThreshold.hasBeenSet()) {
            throw UserError.abort("When setting AlignedHeapChunkSize, LargeArrayThreshold should be explicitly set to a value between 1 and the usable size of an aligned chunk + 1 (currently %d).", maxLargeArrayThreshold);
        }
        long largeArrayThreshold = HeapParameters.getLargeArrayThreshold().rawValue();
        if (largeArrayThreshold <= 0L || largeArrayThreshold > maxLargeArrayThreshold) {
            throw UserError.abort("LargeArrayThreshold (set to %d) should be between 1 and the usable size of an aligned chunk + 1 (currently %d).", largeArrayThreshold, maxLargeArrayThreshold);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word getProducedHeapChunkZapWord() {
        return (Word)producedHeapChunkZapWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getProducedHeapChunkZapInt() {
        return (int)producedHeapChunkZapInt.rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word getConsumedHeapChunkZapWord() {
        return (Word)consumedHeapChunkZapWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getConsumedHeapChunkZapInt() {
        return (int)consumedHeapChunkZapInt.rawValue();
    }

    @Fold
    public static int getMaxSurvivorSpaces() {
        return SerialGCOptions.MaxSurvivorSpaces.getValue();
    }

    public static void setMaximumHeapSize(UnsignedWord value) {
        SubstrateGCOptions.MaxHeapSize.update(value.rawValue());
    }

    public static void setMinimumHeapSize(UnsignedWord value) {
        SubstrateGCOptions.MinHeapSize.update(value.rawValue());
    }

    public static void setMaximumHeapFree(UnsignedWord bytes) {
        SerialGCOptions.MaxHeapFree.update(bytes.rawValue());
    }

    public static UnsignedWord getMaximumHeapFree() {
        return WordFactory.unsigned((long)SerialGCOptions.MaxHeapFree.getValue());
    }

    public static int getHeapChunkHeaderPadding() {
        return SerialAndEpsilonGCOptions.HeapChunkHeaderPadding.getValue();
    }

    static int getMaximumYoungGenerationSizePercent() {
        int result = SerialAndEpsilonGCOptions.MaximumYoungGenerationSizePercent.getValue();
        VMError.guarantee(result >= 0 && result <= 100, "MaximumYoungGenerationSizePercent should be in [0 ..100]");
        return result;
    }

    static int getMaximumHeapSizePercent() {
        int result = SerialAndEpsilonGCOptions.MaximumHeapSizePercent.getValue();
        VMError.guarantee(result >= 0 && result <= 100, "MaximumHeapSizePercent should be in [0 ..100]");
        return result;
    }

    @Fold
    public static UnsignedWord getAlignedHeapChunkSize() {
        return WordFactory.unsigned((long)SerialAndEpsilonGCOptions.AlignedHeapChunkSize.getValue());
    }

    @Fold
    static UnsignedWord getAlignedHeapChunkAlignment() {
        return HeapParameters.getAlignedHeapChunkSize();
    }

    @Fold
    public static UnsignedWord getLargeArrayThreshold() {
        return WordFactory.unsigned((long)SerialAndEpsilonGCOptions.LargeArrayThreshold.getValue());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean getZapProducedHeapChunks() {
        return SerialAndEpsilonGCOptions.ZapChunks.getValue() != false || SerialAndEpsilonGCOptions.ZapProducedHeapChunks.getValue() != false;
    }

    public static boolean getZapConsumedHeapChunks() {
        return SerialAndEpsilonGCOptions.ZapChunks.getValue() != false || SerialAndEpsilonGCOptions.ZapConsumedHeapChunks.getValue() != false;
    }

    static {
        Word.ensureInitialized();
        producedHeapChunkZapInt = WordFactory.unsigned((int)-1163019586);
        producedHeapChunkZapWord = producedHeapChunkZapInt.shiftLeft(32).or(producedHeapChunkZapInt);
        consumedHeapChunkZapInt = WordFactory.unsigned((int)-559038737);
        consumedHeapChunkZapWord = consumedHeapChunkZapInt.shiftLeft(32).or(consumedHeapChunkZapInt);
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static long getUnalignedObjectSize() {
            return HeapParameters.getLargeArrayThreshold().rawValue();
        }
    }
}

