/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.util.VMError;
import java.util.function.Consumer;
import java.util.function.Function;

public final class TypeResult<T> {
    private final String name;
    private final T type;
    private final Throwable exception;

    public static <V> TypeResult<V> forType(String name, V type) {
        return new TypeResult<V>(name, type);
    }

    public static TypeResult<Class<?>> forClass(Class<?> clazz) {
        return new TypeResult(clazz.getName(), clazz);
    }

    public static <T> TypeResult<T> forException(String name, Throwable exception) {
        return new TypeResult<Object>(name, null, exception);
    }

    private TypeResult(String name, T type) {
        this(name, type, null);
    }

    private TypeResult(String name, T type, Throwable exception) {
        this.name = name;
        this.type = type;
        this.exception = exception;
    }

    public boolean isPresent() {
        return this.type != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.type != null) {
            consumer.accept(this.type);
        }
    }

    public T get() {
        return this.type;
    }

    public <U> TypeResult<U> map(Function<T, U> f) {
        if (this.isPresent()) {
            return new TypeResult<U>(this.name, f.apply(this.get()));
        }
        return TypeResult.forException(this.name, this.getException());
    }

    public Throwable getException() {
        return this.exception;
    }

    public T getOrFail() {
        if (this.type != null) {
            return this.type;
        }
        throw VMError.shouldNotReachHere("Type " + this.name + " not found", this.exception);
    }
}

