/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.libc;

import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.c.libc.HostedLibCBase;
import java.util.ServiceLoader;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class HostedLibCFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return HostedLibCBase.isPlatformEquivalent(Platform.LINUX.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        String targetLibC = LibCOptions.UseLibC.getValue();
        ServiceLoader<HostedLibCBase> loader = ServiceLoader.load(HostedLibCBase.class);
        for (HostedLibCBase libc : loader) {
            if (!libc.getName().equals(targetLibC)) continue;
            libc.checkIfLibCSupported();
            ImageSingletons.add(LibCBase.class, (Object)libc);
            return;
        }
        throw UserError.abort("Unknown libc %s selected. Please use one of the available libc implementations.", targetLibC);
    }

    public static class LibCOptions {
        @APIOption(name={"libc"})
        public static final HostedOptionKey<String> UseLibC = new HostedOptionKey<String>(null){

            public String getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return Platform.includedIn(Platform.ANDROID.class) ? "bionic" : System.getProperty("substratevm.HostLibC", "glibc");
                }
                return (String)values.get((Object)this);
            }

            public String getValue(OptionValues values) {
                assert (this.checkDescriptorExists());
                return this.getValueOrDefault(values.getMap());
            }
        };
    }
}

