/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.util.UserError;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class HeapSizeVerifier {
    private static final String MAX_HEAP_SIZE_NAME = "maximum heap size";
    private static final String MIN_HEAP_SIZE_NAME = "minimum heap size";
    private static final String MAX_NEW_SIZE_NAME = "maximum new generation size";

    public static void verifyHeapOptions() {
        HeapSizeVerifier.verifyMaxHeapSize();
        HeapSizeVerifier.verifyMinHeapSize();
        HeapSizeVerifier.verifyMaxNewSize();
    }

    private static void verifyMaxHeapSize() {
        UnsignedWord maxHeapSize = WordFactory.unsigned((long)SubstrateGCOptions.MaxHeapSize.getValue());
        HeapSizeVerifier.verifyMaxHeapSizeAgainstMaxAddressSpaceSize(maxHeapSize);
    }

    private static void verifyMinHeapSize() {
        UnsignedWord minHeapSize = WordFactory.unsigned((long)SubstrateGCOptions.MinHeapSize.getValue());
        HeapSizeVerifier.verifyMinHeapSizeAgainstMaxAddressSpaceSize(minHeapSize);
        UnsignedWord maxHeapSize = WordFactory.unsigned((long)SubstrateGCOptions.MaxHeapSize.getValue());
        if (maxHeapSize.notEqual(0) && minHeapSize.aboveThan(maxHeapSize)) {
            String message = HeapSizeVerifier.formatError(minHeapSize, MIN_HEAP_SIZE_NAME, maxHeapSize, MAX_HEAP_SIZE_NAME);
            throw HeapSizeVerifier.reportError(message);
        }
    }

    private static void verifyMaxNewSize() {
        UnsignedWord maxNewSize = WordFactory.unsigned((long)SubstrateGCOptions.MaxNewSize.getValue());
        HeapSizeVerifier.verifyMaxNewSizeAgainstMaxAddressSpaceSize(maxNewSize);
        UnsignedWord maxHeapSize = WordFactory.unsigned((long)SubstrateGCOptions.MaxHeapSize.getValue());
        if (maxHeapSize.notEqual(0) && maxNewSize.aboveThan(maxHeapSize)) {
            String message = HeapSizeVerifier.formatError(maxNewSize, MAX_NEW_SIZE_NAME, maxHeapSize, MAX_HEAP_SIZE_NAME);
            throw HeapSizeVerifier.reportError(message);
        }
    }

    public static void verifyMinHeapSizeAgainstMaxAddressSpaceSize(UnsignedWord minHeapSize) throws UserError.UserException {
        HeapSizeVerifier.verifyAgainstMaxAddressSpaceSize(minHeapSize, MIN_HEAP_SIZE_NAME);
    }

    public static void verifyMaxHeapSizeAgainstMaxAddressSpaceSize(UnsignedWord maxHeapSize) throws UserError.UserException {
        HeapSizeVerifier.verifyAgainstMaxAddressSpaceSize(maxHeapSize, MAX_HEAP_SIZE_NAME);
    }

    public static void verifyMaxNewSizeAgainstMaxAddressSpaceSize(UnsignedWord maxNewSize) {
        HeapSizeVerifier.verifyAgainstMaxAddressSpaceSize(maxNewSize, MAX_NEW_SIZE_NAME);
    }

    private static void verifyAgainstMaxAddressSpaceSize(UnsignedWord actualValue, String actualValueName) {
        UnsignedWord maxAddressSpaceSize = ReferenceAccess.singleton().getMaxAddressSpaceSize();
        if (actualValue.aboveThan(maxAddressSpaceSize)) {
            Object message = HeapSizeVerifier.formatError(actualValue, actualValueName, maxAddressSpaceSize, "largest possible heap address space");
            if (ReferenceAccess.singleton().getCompressionShift() > 0) {
                message = (String)message + " To allow larger values, please disable compressed references when building the image by adding the option '-H:-UseCompressedReferences'";
            }
            throw HeapSizeVerifier.reportError((String)message);
        }
    }

    private static RuntimeException reportError(String message) throws UserError.UserException {
        if (SubstrateUtil.HOSTED) {
            throw UserError.abort(message, new Object[0]);
        }
        throw new IllegalArgumentException(message);
    }

    private static String formatError(UnsignedWord actualValue, String actualValueName, UnsignedWord maxValue, String maxValueName) {
        return "The specified " + actualValueName + " (" + HeapSizeVerifier.format(actualValue) + ") must not be larger than the " + maxValueName + " (" + HeapSizeVerifier.format(maxValue) + ").";
    }

    private static String format(UnsignedWord bytes) {
        int index;
        String[] units = new String[]{"", "k", "m", "g", "t"};
        UnsignedWord value = bytes;
        for (index = 0; value.unsignedRemainder(1024).equal(0) && index < units.length - 1; ++index) {
            value = value.unsignedDivide(1024);
        }
        return value.rawValue() + units[index];
    }
}

