/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
public class NativeImageDebugInfoStripFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.StripDebugInfo.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        FeatureImpl.AfterImageWriteAccessImpl accessImpl = (FeatureImpl.AfterImageWriteAccessImpl)access;
        DebugContext debugContext = new DebugContext.Builder(HostedOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection())).build();
        try (Indent indent = debugContext.logAndIndent("Stripping debuginfo");){
            switch (ObjectFile.getNativeFormat()) {
                case ELF: {
                    NativeImageDebugInfoStripFeature.stripLinux(accessImpl);
                    return;
                }
                case PECOFF: {
                    return;
                }
                case MACH_O: {
                    return;
                }
                default: {
                    throw UserError.abort("Unsupported object file format", new Object[0]);
                }
            }
        }
    }

    @SuppressFBWarnings(value={""}, justification="FB reports null pointer dereferencing although it is not possible in this case.")
    private static void stripLinux(FeatureImpl.AfterImageWriteAccessImpl accessImpl) {
        String objcopyExe = "objcopy";
        String debugExtension = ".debug";
        Path imagePath = accessImpl.getImagePath();
        if (imagePath == null) {
            assert (!Platform.includedIn(InternalPlatform.NATIVE_ONLY.class));
            return;
        }
        Path imageName = imagePath.getFileName();
        boolean objcopyAvailable = false;
        try {
            objcopyAvailable = FileUtils.executeCommand(objcopyExe, "--version") == 0;
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException e) {
            throw new InterruptImageBuilding("Interrupted during checking for " + objcopyExe + " availability");
        }
        if (!objcopyAvailable) {
            LogUtils.warning((String)String.format("%s not available. The debuginfo will remain embedded in the executable.", objcopyExe));
        } else {
            try {
                Path outputDirectory = imagePath.getParent();
                String imageFilePath = outputDirectory.resolve(imageName).toString();
                if (SubstrateOptions.useDebugInfoGeneration()) {
                    String debugInfoName = imageName + debugExtension;
                    Path debugInfoFilePath = outputDirectory.resolve(debugInfoName);
                    FileUtils.executeCommand(objcopyExe, "--only-keep-debug", imageFilePath, debugInfoFilePath.toString());
                    BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.DEBUG_INFO, debugInfoFilePath);
                    FileUtils.executeCommand(objcopyExe, "--add-gnu-debuglink=" + debugInfoFilePath, imageFilePath);
                }
                if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                    FileUtils.executeCommand(objcopyExe, "--strip-all", imageFilePath);
                } else {
                    FileUtils.executeCommand(objcopyExe, "--strip-debug", imageFilePath);
                }
            }
            catch (IOException e) {
                throw UserError.abort("Generation of separate debuginfo file failed", e);
            }
            catch (InterruptedException e) {
                throw new InterruptImageBuilding("Interrupted during debuginfo file splitting of image " + imageName);
            }
        }
    }
}

