/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

final class LegacyResourceConfigurationParser
extends ResourceConfigurationParser {
    LegacyResourceConfigurationParser(ConfigurationConditionResolver conditionResolver, ResourcesRegistry registry, boolean strictConfiguration) {
        super(conditionResolver, registry, strictConfiguration);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        this.parseTopLevelObject(LegacyResourceConfigurationParser.asMap(json, "first level of document must be an object"));
    }

    @Override
    protected ConfigurationCondition parseCondition(EconomicMap<String, Object> data) {
        return this.parseCondition(data, false);
    }

    private void parseTopLevelObject(EconomicMap<String, Object> obj) {
        Object resourcesObject = null;
        Object bundlesObject = null;
        Object globsObject = null;
        MapCursor cursor = obj.getEntries();
        while (cursor.advance()) {
            if ("resources".equals(cursor.getKey())) {
                resourcesObject = cursor.getValue();
                continue;
            }
            if ("bundles".equals(cursor.getKey())) {
                bundlesObject = cursor.getValue();
                continue;
            }
            if (!"globs".equals(cursor.getKey())) continue;
            globsObject = cursor.getValue();
        }
        if (resourcesObject != null) {
            this.parseResourcesObject(resourcesObject);
        }
        if (bundlesObject != null) {
            this.parseBundlesObject(bundlesObject);
        }
        if (globsObject != null) {
            this.parseGlobsObject(globsObject);
        }
    }

    protected void parseResourcesObject(Object resourcesObject) {
        block4: {
            block3: {
                if (!(resourcesObject instanceof EconomicMap)) break block3;
                EconomicMap resourcesObjectMap = (EconomicMap)resourcesObject;
                this.checkAttributes((EconomicMap<String, Object>)resourcesObjectMap, "resource descriptor object", Collections.singleton("includes"), Collections.singleton("excludes"));
                Object includesObject = resourcesObjectMap.get((Object)"includes");
                Object excludesObject = resourcesObjectMap.get((Object)"excludes");
                List<Object> includes = LegacyResourceConfigurationParser.asList(includesObject, "Attribute 'includes' must be a list of resources");
                for (Object object : includes) {
                    this.parsePatternEntry(object, this.registry::addResources, "'includes' list");
                }
                if (excludesObject == null) break block4;
                List<Object> excludes = LegacyResourceConfigurationParser.asList(excludesObject, "Attribute 'excludes' must be a list of resources");
                for (Object object : excludes) {
                    this.parsePatternEntry(object, this.registry::ignoreResources, "'excludes' list");
                }
                break block4;
            }
            List<Object> resources = LegacyResourceConfigurationParser.asList(resourcesObject, "Attribute 'resources' must be a list of resources");
            for (Object object : resources) {
                this.parsePatternEntry(object, this.registry::addResources, "'resources' list");
            }
        }
    }

    private void parsePatternEntry(Object data, BiConsumer<ConfigurationCondition, String> resourceRegistry, String parentType) {
        EconomicMap<String, Object> resource = LegacyResourceConfigurationParser.asMap(data, "Elements of " + parentType + " must be a resource descriptor object");
        this.checkAttributes(resource, "regex resource descriptor object", Collections.singletonList("pattern"), Collections.singletonList("condition"));
        TypeResult<ConfigurationCondition> resolvedConfigurationCondition = this.conditionResolver.resolveCondition(this.parseCondition(resource, false));
        if (!resolvedConfigurationCondition.isPresent()) {
            return;
        }
        Object valueObject = resource.get((Object)"pattern");
        String value = LegacyResourceConfigurationParser.asString(valueObject, "pattern");
        resourceRegistry.accept(resolvedConfigurationCondition.get(), value);
    }
}

