/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import java.nio.ByteBuffer;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class SubstrateSegfaultHandler {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    static long offsetOfStaticFieldWithWellKnownValue;
    private static final long MARKER_VALUE = 81985529216486895L;
    private static final CGlobalData<Word> OFFSET_OF_STATIC_FIELD_WITH_WELL_KNOWN_VALUE;
    private static long staticFieldWithWellKnownValue;
    private boolean installed;

    @Fold
    public static SubstrateSegfaultHandler singleton() {
        return (SubstrateSegfaultHandler)ImageSingletons.lookup(SubstrateSegfaultHandler.class);
    }

    public static boolean isInstalled() {
        return SubstrateSegfaultHandler.singleton().installed;
    }

    public void install() {
        this.installInternal();
        this.installed = true;
    }

    protected abstract void installInternal();

    protected abstract void printSignalInfo(Log var1, PointerBase var2);

    @Uninterruptible(reason="Thread state not set up yet.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.")
    protected static boolean tryEnterIsolate(RegisterDumper.Context context) {
        Isolate isolate = SingleIsolateSegfaultSetup.singleton().getIsolate();
        if (isolate.rawValue() != -1L) {
            int error = CEntryPointActions.enterAttachThreadFromCrashHandler(isolate);
            return error == 0;
        }
        if (SubstrateOptions.useLLVMBackend()) {
            return false;
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue() && SubstrateSegfaultHandler.tryEnterIsolateViaThreadRegister(context)) {
            return true;
        }
        return SubstrateOptions.SpawnIsolates.getValue() != false && SubstrateSegfaultHandler.tryEnterIsolateViaHeapBaseRegister(context);
    }

    @Uninterruptible(reason="Thread state not set up yet.")
    @NeverInline(value="Prevent register writes from floating")
    private static boolean tryEnterIsolateViaThreadRegister(RegisterDumper.Context context) {
        Isolate isolate;
        WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)WordFactory.nullPointer());
        IsolateThread isolateThread = (IsolateThread)RegisterDumper.singleton().getThreadPointer(context);
        if (isolateThread.isNonNull() && SubstrateSegfaultHandler.isValid(isolate = VMThreads.IsolateTL.get(isolateThread))) {
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                CEntryPointSnippets.setHeapBase((PointerBase)isolate);
            }
            WriteCurrentVMThreadNode.writeCurrentVMThread(isolateThread);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Thread state not set up yet.")
    @NeverInline(value="Prevent register writes from floating")
    private static boolean tryEnterIsolateViaHeapBaseRegister(RegisterDumper.Context context) {
        CEntryPointSnippets.setHeapBase(WordFactory.nullPointer());
        Isolate isolate = (Isolate)RegisterDumper.singleton().getHeapBase(context);
        if (SubstrateSegfaultHandler.isValid(isolate)) {
            int error = CEntryPointActions.enterAttachThreadFromCrashHandler(isolate);
            return error == 0;
        }
        return false;
    }

    @Uninterruptible(reason="Thread state not set up yet.")
    private static boolean isValid(Isolate isolate) {
        if (Isolates.checkIsolate(isolate) != 0) {
            return false;
        }
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            UnsignedWord staticFieldsOffsets = ReferenceAccess.singleton().getCompressedRepresentation(StaticFieldsSupport.getStaticPrimitiveFields());
            UnsignedWord wellKnownFieldOffset = staticFieldsOffsets.shiftLeft(ReferenceAccess.singleton().getCompressionShift()).add((UnsignedWord)OFFSET_OF_STATIC_FIELD_WITH_WELL_KNOWN_VALUE.get().readWord(0));
            Pointer wellKnownField = ((Pointer)isolate).add(wellKnownFieldOffset);
            return wellKnownField.readLong(0) == 81985529216486895L;
        }
        return true;
    }

    @Uninterruptible(reason="Must be uninterruptible until we get immune to safepoints.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.")
    protected static void dump(PointerBase signalInfo, RegisterDumper.Context context) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        SubstrateSegfaultHandler.dumpInterruptibly(signalInfo, context);
    }

    private static void dumpInterruptibly(PointerBase signalInfo, RegisterDumper.Context context) {
        PointerBase callerIP = RegisterDumper.singleton().getIP(context);
        LogHandler logHandler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
        Log log = Log.enterFatalContext(logHandler, (CodePointer)callerIP, "[ [ SubstrateSegfaultHandler caught a segfault. ] ]", null);
        if (log != null) {
            log.newline();
            log.string("[ [ SubstrateSegfaultHandler caught a segfault in thread ").zhex((WordBase)CurrentIsolate.getCurrentThread()).string(" ] ]").newline();
            ((SubstrateSegfaultHandler)ImageSingletons.lookup(SubstrateSegfaultHandler.class)).printSignalInfo(log, signalInfo);
            PointerBase sp = RegisterDumper.singleton().getSP(context);
            PointerBase ip = RegisterDumper.singleton().getIP(context);
            boolean printedDiagnostics = SubstrateDiagnostics.printFatalError(log, (Pointer)sp, (CodePointer)ip, context, false);
            if (printedDiagnostics) {
                log.string("Segfault detected, aborting process. ").string("Use '-XX:-InstallSegfaultHandler' to disable the segfault handler at run time and create a core dump instead. ").string("Rebuild with '-R:-InstallSegfaultHandler' to disable the handler permanently at build time.").newline().newline();
            }
        }
        logHandler.fatalError();
    }

    protected static void printSegfaultAddressInfo(Log log, long addr) {
        log.zhex(addr);
        if (addr != 0L) {
            long delta = addr - CurrentIsolate.getIsolate().rawValue();
            String sign = delta >= 0L ? "+" : "-";
            log.string(" (heapBase ").string(sign).string(" ").signed(Math.abs(delta)).string(")");
        }
    }

    static {
        OFFSET_OF_STATIC_FIELD_WITH_WELL_KNOWN_VALUE = CGlobalDataFactory.createBytes(() -> {
            assert (ConfigurationValues.getTarget().wordSize == 8);
            return ByteBuffer.allocate(8).order(ConfigurationValues.getTarget().arch.getByteOrder()).putLong(offsetOfStaticFieldWithWellKnownValue).array();
        });
        staticFieldWithWellKnownValue = 81985529216486895L;
    }

    public static class SingleIsolateSegfaultSetup
    implements IsolateListenerSupport.IsolateListener {
        private static final CGlobalData<Pointer> baseIsolate = CGlobalDataFactory.createWord();

        @Fold
        public static SingleIsolateSegfaultSetup singleton() {
            return (SingleIsolateSegfaultSetup)ImageSingletons.lookup(SingleIsolateSegfaultSetup.class);
        }

        @Override
        @Uninterruptible(reason="Thread state not yet set up.")
        public void afterCreateIsolate(Isolate isolate) {
            PointerBase value = (PointerBase)baseIsolate.get().compareAndSwapWord(0, (WordBase)((Isolate)WordFactory.zero()), (WordBase)isolate, LocationIdentity.ANY_LOCATION);
            if (!value.isNull()) {
                baseIsolate.get().writeWord(0, (WordBase)WordFactory.signed((int)-1));
            }
        }

        @Uninterruptible(reason="Thread state not yet set up.")
        public Isolate getIsolate() {
            return (Isolate)baseIsolate.get().readWord(0);
        }
    }

    public static class Options {
        static final RuntimeOptionKey<Boolean> InstallSegfaultHandler = new RuntimeOptionKey<Object>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }
}

