/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ElementInfo {
    protected final String name;
    private final List<ElementInfo> children;
    protected ElementInfo parent;
    private static final String ID_DELIMINATOR = ":";

    protected ElementInfo(String name) {
        this.name = name;
        this.children = new ArrayList<ElementInfo>();
    }

    public String getName() {
        return this.name;
    }

    public ElementInfo getParent() {
        return this.parent;
    }

    public List<ElementInfo> getChildren() {
        return this.children;
    }

    protected <T extends ElementInfo> T adoptChild(T newChild) {
        assert (newChild.parent == null);
        newChild.parent = this;
        this.children.add(newChild);
        return newChild;
    }

    protected void adoptChildren(Collection<? extends ElementInfo> newChildren) {
        for (ElementInfo elementInfo : newChildren) {
            this.adoptChild(elementInfo);
        }
    }

    public void mergeChildrenAndDelete(ElementInfo target) {
        for (ElementInfo child : this.children) {
            assert (child.parent == this);
            child.parent = target;
            target.children.add(child);
        }
        assert (this.parent.children.contains(this));
        this.parent.children.remove(this);
    }

    public final String getUniqueID() {
        StringBuilder result = new StringBuilder();
        if (this.getParent() != null) {
            result.append(this.getParent().getUniqueID()).append(ID_DELIMINATOR);
        }
        result.append(ClassUtil.getUnqualifiedName(this.getClass())).append(ID_DELIMINATOR).append(this.getName().replaceAll("\\W", "_"));
        return result.toString();
    }

    public abstract Object getAnnotatedElement();

    public abstract void accept(InfoTreeVisitor var1);

    public final String toString() {
        return this.getUniqueID();
    }
}

