/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util.json;

import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public interface JsonPrinter<T> {
    public void print(T var1, JsonWriter var2) throws IOException;

    public static <T> void printCollection(JsonWriter writer, Collection<T> collection, Comparator<T> comparator, JsonPrinter<T> elementPrinter) throws IOException {
        writer.append('[');
        String prefix = "";
        Collection<T> ordered = collection;
        if (comparator != null) {
            ordered = new ArrayList<T>(collection);
            ((List)ordered).sort(comparator);
        }
        for (T t : ordered) {
            writer.append(prefix);
            elementPrinter.print(t, writer);
            prefix = ", ";
        }
        writer.append("]");
    }
}

