/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.CodeInfoMemoryWalker;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.UnsignedWord;

public class ImageCodeInfo {
    public static final String CODE_INFO_NAME = "image code";
    private final byte[] runtimeCodeInfoData;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final HostedImageCodeInfo hostedImageCodeInfo = new HostedImageCodeInfo();
    @UnknownPrimitiveField
    private CodePointer codeStart;
    @UnknownPrimitiveField
    private UnsignedWord codeSize;
    @UnknownPrimitiveField
    private UnsignedWord dataOffset;
    @UnknownPrimitiveField
    private UnsignedWord dataSize;
    @UnknownPrimitiveField
    private UnsignedWord codeAndDataMemorySize;
    private final Object[] objectFields;
    @UnknownObjectField(types={byte[].class})
    byte[] codeInfoIndex;
    @UnknownObjectField(types={byte[].class})
    byte[] codeInfoEncodings;
    @UnknownObjectField(types={byte[].class})
    byte[] referenceMapEncoding;
    @UnknownObjectField(types={byte[].class})
    byte[] frameInfoEncodings;
    @UnknownObjectField(types={Object[].class})
    Object[] frameInfoObjectConstants;
    @UnknownObjectField(types={Class[].class})
    Class<?>[] frameInfoSourceClasses;
    @UnknownObjectField(types={String[].class})
    String[] frameInfoSourceMethodNames;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ImageCodeInfo() {
        NonmovableObjectArray objfields = NonmovableArrays.createObjectArray(Object[].class, 3);
        NonmovableArrays.setObject(objfields, 1, CODE_INFO_NAME);
        NonmovableArrays.setObject(objfields, 0, new CodeInfoTether(true));
        this.objectFields = (Object[])NonmovableArrays.getHostedArray(objfields);
        int runtimeInfoSize = SizeOf.get(CodeInfoImpl.class);
        this.runtimeCodeInfoData = new byte[runtimeInfoSize];
    }

    @Uninterruptible(reason="Executes during isolate creation.")
    CodeInfo prepareCodeInfo() {
        CodeInfoImpl info = (CodeInfoImpl)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)this.runtimeCodeInfoData), 0);
        assert (info.getCodeStart().isNull()) : "already initialized";
        info.setObjectFields(NonmovableArrays.fromImageHeap(this.objectFields));
        info.setCodeStart(this.codeStart);
        info.setCodeSize(this.codeSize);
        info.setDataOffset(this.dataOffset);
        info.setDataSize(this.dataSize);
        info.setCodeAndDataMemorySize(this.codeAndDataMemorySize);
        info.setCodeInfoIndex(NonmovableArrays.fromImageHeap((Object)this.codeInfoIndex));
        info.setCodeInfoEncodings(NonmovableArrays.fromImageHeap((Object)this.codeInfoEncodings));
        info.setStackReferenceMapEncoding(NonmovableArrays.fromImageHeap((Object)this.referenceMapEncoding));
        info.setFrameInfoEncodings(NonmovableArrays.fromImageHeap((Object)this.frameInfoEncodings));
        info.setFrameInfoObjectConstants(NonmovableArrays.fromImageHeap(this.frameInfoObjectConstants));
        info.setFrameInfoSourceClasses(NonmovableArrays.fromImageHeap(this.frameInfoSourceClasses));
        info.setFrameInfoSourceMethodNames(NonmovableArrays.fromImageHeap(this.frameInfoSourceMethodNames));
        return info;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer getCodeStart() {
        return this.codeStart;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public NonmovableArray<Byte> getStackReferenceMapEncoding() {
        return NonmovableArrays.fromImageHeap((Object)this.referenceMapEncoding);
    }

    public boolean walkImageCode(MemoryWalker.Visitor visitor) {
        return visitor.visitCode(CodeInfoTable.getImageCodeInfo(), (MemoryWalker.CodeAccess)ImageSingletons.lookup(CodeInfoMemoryWalker.class));
    }

    public HostedImageCodeInfo getHostedImageCodeInfo() {
        return this.hostedImageCodeInfo;
    }

    public long getTotalByteArraySize() {
        return this.codeInfoIndex.length + this.codeInfoEncodings.length + this.referenceMapEncoding.length + this.frameInfoEncodings.length;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public class HostedImageCodeInfo
    implements CodeInfoImpl {
        @Override
        public CodePointer getCodeStart() {
            return ImageCodeInfo.this.codeStart;
        }

        @Override
        public UnsignedWord getCodeSize() {
            return ImageCodeInfo.this.codeSize;
        }

        @Override
        public UnsignedWord getDataOffset() {
            return ImageCodeInfo.this.dataOffset;
        }

        @Override
        public UnsignedWord getDataSize() {
            return ImageCodeInfo.this.dataSize;
        }

        @Override
        public UnsignedWord getCodeAndDataMemorySize() {
            return ImageCodeInfo.this.codeAndDataMemorySize;
        }

        @Override
        public NonmovableArray<Byte> getStackReferenceMapEncoding() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.referenceMapEncoding);
        }

        @Override
        public void setCodeStart(CodePointer value) {
            ImageCodeInfo.this.codeStart = value;
        }

        @Override
        public void setCodeSize(UnsignedWord value) {
            ImageCodeInfo.this.codeSize = value;
        }

        @Override
        public void setDataOffset(UnsignedWord value) {
            ImageCodeInfo.this.dataOffset = value;
        }

        @Override
        public void setDataSize(UnsignedWord value) {
            ImageCodeInfo.this.dataSize = value;
        }

        @Override
        public void setCodeAndDataMemorySize(UnsignedWord value) {
            ImageCodeInfo.this.codeAndDataMemorySize = value;
        }

        @Override
        public NonmovableArray<Byte> getCodeInfoIndex() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.codeInfoIndex);
        }

        @Override
        public void setCodeInfoIndex(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.codeInfoIndex = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableArray<Byte> getCodeInfoEncodings() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.codeInfoEncodings);
        }

        @Override
        public void setCodeInfoEncodings(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.codeInfoEncodings = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public void setStackReferenceMapEncoding(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.referenceMapEncoding = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableArray<Byte> getFrameInfoEncodings() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.frameInfoEncodings);
        }

        @Override
        public void setFrameInfoEncodings(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.frameInfoEncodings = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<Object> getFrameInfoObjectConstants() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.frameInfoObjectConstants);
        }

        @Override
        public void setFrameInfoObjectConstants(NonmovableObjectArray<Object> array) {
            ImageCodeInfo.this.frameInfoObjectConstants = (Object[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<Class<?>> getFrameInfoSourceClasses() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.frameInfoSourceClasses);
        }

        @Override
        public void setFrameInfoSourceClasses(NonmovableObjectArray<Class<?>> array) {
            ImageCodeInfo.this.frameInfoSourceClasses = (Class[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<String> getFrameInfoSourceMethodNames() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.frameInfoSourceMethodNames);
        }

        @Override
        public void setFrameInfoSourceMethodNames(NonmovableObjectArray<String> array) {
            ImageCodeInfo.this.frameInfoSourceMethodNames = (String[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public void setObjectFields(NonmovableObjectArray<Object> fields) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableObjectArray<Object> getObjectFields() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public int getTier() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setTier(int tier) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public int getState() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setState(int state) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Byte> getCodeConstantsReferenceMapEncoding() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeConstantsReferenceMapEncoding(NonmovableArray<Byte> objectsReferenceMapEncoding) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public long getCodeConstantsReferenceMapIndex() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeConstantsReferenceMapIndex(long objectsReferenceMapIndex) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Integer> getDeoptimizationStartOffsets() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationStartOffsets(NonmovableArray<Integer> deoptimizationStartOffsets) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Byte> getDeoptimizationEncodings() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationEncodings(NonmovableArray<Byte> deoptimizationEncodings) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableObjectArray<Object> getDeoptimizationObjectConstants() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationObjectConstants(NonmovableObjectArray<Object> deoptimizationObjectConstants) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> getCodeObserverHandles() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeObserverHandles(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> handles) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public Word getGCData() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setAllObjectsAreInImageHeap(boolean value) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public boolean getAllObjectsAreInImageHeap() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        public boolean isNull() {
            return false;
        }

        public boolean isNonNull() {
            return !this.isNull();
        }

        public boolean equal(ComparableWord val) {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        public boolean notEqual(ComparableWord val) {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        public long rawValue() {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }
    }
}

