/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.SubstitutionReportFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.util.CPUType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class NativeImageOptions {
    public static final int DEFAULT_MAX_ANALYSIS_SCALING = 16;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> CPUFeatures = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    @APIOption(name={"list-cpu-features"})
    public static final HostedOptionKey<Boolean> ListCPUFeatures = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> RuntimeCheckedCPUFeatures = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    public static final String MICRO_ARCHITECTURE_NATIVE = "native";
    public static final String MICRO_ARCHITECTURE_COMPATIBILITY = "compatibility";
    public static final String MICRO_ARCHITECTURE_LIST = "list";
    @APIOption(name={"-march"})
    public static final HostedOptionKey<String> MicroArchitecture = new HostedOptionKey<String>(null){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
            if (NativeImageOptions.MICRO_ARCHITECTURE_LIST.equals(newValue)) {
                CPUType.printList();
                throw new InterruptImageBuilding("");
            }
        }
    };
    public static final HostedOptionKey<Boolean> NativeArchitecture = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            MicroArchitecture.update(values, newValue != false ? NativeImageOptions.MICRO_ARCHITECTURE_NATIVE : null);
        }
    };
    public static final HostedOptionKey<Boolean> PrintUniverse = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintAOTCompilation = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintHeapHistogram = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintMethodHistogram = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintImageElementSizes = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintImageHeapPartitionSizes = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintFeatures = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<String> TempDirectory = new HostedOptionKey<String>("");
    public static final HostedOptionKey<Boolean> SuppressStderr = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> SuppressStdout = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> AllowFoldMethods = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"report-unsupported-elements-at-runtime"})
    public static final HostedOptionKey<Boolean> ReportUnsupportedElementsAtRuntime = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"allow-incomplete-classpath"}, deprecated="Allowing an incomplete classpath is now the default. Use --link-at-build-time to report linking errors at image build time for a class or package.")
    static final HostedOptionKey<Boolean> AllowIncompleteClasspath = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<String> CStandard = new HostedOptionKey<String>("C89");
    public static final HostedOptionKey<Integer> NumberOfThreads = new HostedOptionKey<Integer>(Math.min(Runtime.getRuntime().availableProcessors(), 32));
    public static final HostedOptionKey<Integer> NumberOfAnalysisThreads = new HostedOptionKey<Integer>(-1);
    public static final HostedOptionKey<Boolean> ReturnAfterAnalysis = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> ExitAfterAnalysis = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> ExitAfterRelocatableImageWrite = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> ThrowUnsafeOffsetErrors = new HostedOptionKey<Boolean>(true);
    public static final HostedOptionKey<Boolean> ReportUnsafeOffsetWarnings = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> UnsafeOffsetWarningsAreFatal = new HostedOptionKey<Boolean>(false);
    private static final String DEFAULT_ERROR_FILE_NAME = "svm_err_b_%t_pid%p.md";
    public static final HostedOptionKey<String> ErrorFile = new HostedOptionKey<String>("svm_err_b_%t_pid%p.md");
    public static final HostedOptionKey<Boolean> ReportExceptionStackTraces = new HostedOptionKey<Boolean>(NativeImageOptions.areAssertionsEnabled());
    public static final HostedOptionKey<Integer> MaxReachableTypes = new HostedOptionKey<Integer>(-1);
    @BundleMember(role=BundleMember.Role.Output)
    public static final HostedOptionKey<LocatableMultiOptionValue.Paths> DiagnosticsDir = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithDefaults(Paths.get("reports", ReportUtils.timeStampedFileName((String)"diagnostics", (String)""))));
    public static final HostedOptionKey<Boolean> DiagnosticsMode = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                ClassInitializationOptions.PrintClassInitialization.update(values, true);
                SubstitutionReportFeature.Options.ReportPerformedSubstitutions.update(values, true);
                SubstrateOptions.DumpTargetInfo.update(values, true);
                PrintFeatures.update(values, true);
                ReportExceptionStackTraces.update(values, true);
            }
        }
    };

    private static boolean areAssertionsEnabled() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertsEnabled;
    }

    public static CStandards getCStandard() {
        try {
            return CStandards.valueOf(CStandard.getValue());
        }
        catch (IllegalArgumentException e) {
            throw UserError.abort("C standard %s is not supported. Supported standards are: %s", CStandard.getValue(), Arrays.toString((Object[])CStandards.values()));
        }
    }

    public static final Path getErrorFilePath(OptionValues hostedOptionValues) {
        String errorFile = (String)ErrorFile.getValue(hostedOptionValues);
        Path expandedErrorFile = NativeImageOptions.expandErrorFile(errorFile);
        if (expandedErrorFile.isAbsolute()) {
            throw UserError.abort("The error filename mask specified with " + SubstrateOptionsParser.commandArgument(ErrorFile, errorFile) + " is not allowed to be an absolute path.", new Object[0]);
        }
        return NativeImageGenerator.generatedFiles(hostedOptionValues).resolve(expandedErrorFile);
    }

    private static Path expandErrorFile(String errorFile) {
        String timestamp = new SimpleDateFormat("yyyyMMdd'T'HHmmss.SSS").format(new Date(GraalServices.getGlobalTimeStamp()));
        return Path.of(errorFile.replaceAll("%p", GraalServices.getExecutionID()).replaceAll("%t", timestamp), new String[0]);
    }

    public static int getMaximumNumberOfConcurrentThreads(OptionValues optionValues) {
        int maxNumberOfThreads = (Integer)NumberOfThreads.getValue(optionValues);
        if (maxNumberOfThreads < 0) {
            throw UserError.abort("Number of threads can't be negative. Set the NumberOfThreads flag to a positive value.", new Object[0]);
        }
        return maxNumberOfThreads;
    }

    public static int getMaximumNumberOfAnalysisThreads(OptionValues optionValues) {
        int analysisThreads;
        int optionValue = (Integer)NumberOfAnalysisThreads.getValue(optionValues);
        int n = analysisThreads = NumberOfAnalysisThreads.hasBeenSet(optionValues) ? optionValue : Math.min(NativeImageOptions.getMaximumNumberOfConcurrentThreads(optionValues), 16);
        if (analysisThreads < 0) {
            throw UserError.abort("Number of analysis threads can't be negative. Set the NumberOfAnalysisThreads flag to a positive value.", new Object[0]);
        }
        if (analysisThreads > (Integer)NumberOfThreads.getValue(optionValues)) {
            throw UserError.abort("Number of analysis threads can't be larger than NumberOfThreads. Set the NumberOfAnalysisThreads flag to a positive value smaller than NumberOfThreads.", new Object[0]);
        }
        return analysisThreads;
    }

    public static enum CStandards {
        C89,
        C99,
        C11;


        public boolean compatibleWith(CStandards standard) {
            return this.compareTo(standard) >= 0;
        }
    }
}

