/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class XOptions {
    private static final XFlag[] XOPTIONS = new XFlag[]{new XFlag("ms", SubstrateGCOptions.MinHeapSize), new XFlag("mx", SubstrateGCOptions.MaxHeapSize), new XFlag("mn", SubstrateGCOptions.MaxNewSize), new XFlag("ss", SubstrateOptions.StackSize)};

    public static boolean parse(String keyAndValue, EconomicMap<OptionKey<?>, Object> values) {
        XFlag xFlag = XOptions.findXFlag(keyAndValue);
        if (xFlag != null) {
            long value = XOptions.parse(xFlag, keyAndValue);
            xFlag.optionKey.update(values, value);
            return true;
        }
        return false;
    }

    public static boolean setOption(String keyAndValue) {
        XFlag xFlag = XOptions.findXFlag(keyAndValue);
        if (xFlag != null) {
            long value = XOptions.parse(xFlag, keyAndValue);
            xFlag.optionKey.update(value);
            return true;
        }
        return false;
    }

    private static XFlag findXFlag(String keyAndValue) {
        for (XFlag xFlag : XOPTIONS) {
            if (!keyAndValue.startsWith(xFlag.name)) continue;
            return xFlag;
        }
        return null;
    }

    private static long parse(XFlag xFlag, String keyAndValue) {
        String valueString = keyAndValue.substring(xFlag.name.length());
        try {
            return SubstrateOptionsParser.parseLong(valueString);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid option '-X" + keyAndValue + "' does not specify a valid number.");
        }
    }

    private static class XFlag {
        final String name;
        final RuntimeOptionKey<Long> optionKey;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        XFlag(String name, RuntimeOptionKey<Long> optionKey) {
            this.name = name;
            this.optionKey = optionKey;
        }
    }
}

