/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.headers.Process;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

final class WindowsVMMutex
extends VMMutex {
    UnsignedWord structOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    WindowsVMMutex(String name) {
        super(name);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Process.PCRITICAL_SECTION getStructPointer() {
        return (Process.PCRITICAL_SECTION)Word.objectToUntrackedPointer((Object)WindowsVMLockSupport.singleton().syncStructs).add(this.structOffset);
    }

    @Override
    public VMMutex lock() {
        this.assertNotOwner("Recursive locking is not supported");
        Process.EnterCriticalSection(this.getStructPointer());
        this.setOwnerToCurrentThread();
        return this;
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransition() {
        this.assertNotOwner("Recursive locking is not supported");
        Process.NoTransitions.EnterCriticalSection(this.getStructPointer());
        this.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransitionUnspecifiedOwner() {
        Process.NoTransitions.EnterCriticalSection(this.getStructPointer());
        this.setOwnerToUnspecified();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlock() {
        this.clearCurrentThreadOwner();
        Process.NoTransitions.LeaveCriticalSection(this.getStructPointer());
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.")
    public void unlockNoTransitionUnspecifiedOwner() {
        this.clearUnspecifiedOwner();
        Process.NoTransitions.LeaveCriticalSection(this.getStructPointer());
    }
}

