/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrEventWriteStatus;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.util.VMError;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JfrNativeEventWriter {
    private static final int SIZE_SAFETY_CUSHION = 1;
    private static final int MAX_PADDED_INT_VALUE = 0x1FFFFFFF;
    public static final int MAX_COMPRESSED_BYTE_VALUE = 127;

    private JfrNativeEventWriter() {
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void beginSmallEvent(JfrNativeEventWriterData data, JfrEvent event) {
        JfrNativeEventWriter.beginEvent(data, event, false);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void beginEvent(JfrNativeEventWriterData data, JfrEvent event, boolean large) {
        assert (SubstrateJVM.get().isRecording());
        assert (JfrNativeEventWriterDataAccess.verify(data) || !JfrNativeEventWriter.isValid(data));
        assert (JfrNativeEventWriter.getUncommittedSize(data).equal(0));
        if (large) {
            JfrNativeEventWriter.reserve(data, 4);
        } else {
            JfrNativeEventWriter.reserve(data, 1);
        }
        JfrNativeEventWriter.putLong(data, event.getId());
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static JfrEventWriteStatus endSmallEvent(JfrNativeEventWriterData data) {
        JfrEventWriteStatus status = JfrNativeEventWriter.endEvent(data, false);
        VMError.guarantee(status != JfrEventWriteStatus.RetryLarge);
        return status;
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static JfrEventWriteStatus endEvent(JfrNativeEventWriterData data, boolean large) {
        if (!JfrNativeEventWriter.isValid(data)) {
            return JfrEventWriteStatus.Failure;
        }
        UnsignedWord written = JfrNativeEventWriter.getUncommittedSize(data);
        if (large) {
            if (written.belowOrEqual(4) || written.aboveThan(0x1FFFFFFF)) {
                JfrNativeEventWriter.cancel(data);
                return JfrEventWriteStatus.Failure;
            }
            Pointer currentPos = data.getCurrentPos();
            data.setCurrentPos(data.getStartPos());
            JfrNativeEventWriter.putPaddedInt(data, (int)written.rawValue());
            data.setCurrentPos(currentPos);
            JfrNativeEventWriter.commitEvent(data);
            return JfrEventWriteStatus.Success;
        }
        if (written.belowOrEqual(1)) {
            JfrNativeEventWriter.cancel(data);
            return JfrEventWriteStatus.Failure;
        }
        if (written.aboveThan(127)) {
            JfrNativeEventWriter.reset(data);
            return JfrEventWriteStatus.RetryLarge;
        }
        Pointer currentPos = data.getCurrentPos();
        data.setCurrentPos(data.getStartPos());
        JfrNativeEventWriter.putByte(data, (byte)written.rawValue());
        data.setCurrentPos(currentPos);
        JfrNativeEventWriter.commitEvent(data);
        return JfrEventWriteStatus.Success;
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putBoolean(JfrNativeEventWriterData data, boolean i) {
        byte value = (byte)(i ? 1 : 0);
        JfrNativeEventWriter.putByte(data, value);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putByte(JfrNativeEventWriterData data, byte i) {
        if (JfrNativeEventWriter.ensureSize(data, 1)) {
            JfrNativeEventWriter.putUncheckedByte(data, i);
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putChar(JfrNativeEventWriterData data, char v) {
        if (JfrNativeEventWriter.ensureSize(data, 2)) {
            JfrNativeEventWriter.putUncheckedLong(data, v);
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putShort(JfrNativeEventWriterData data, short v) {
        if (JfrNativeEventWriter.ensureSize(data, 2)) {
            JfrNativeEventWriter.putUncheckedLong(data, v & 0xFFFF);
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putInt(JfrNativeEventWriterData data, int v) {
        if (JfrNativeEventWriter.ensureSize(data, 4)) {
            JfrNativeEventWriter.putUncheckedLong(data, (long)v & 0xFFFFFFFFL);
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putLong(JfrNativeEventWriterData data, long v) {
        if (JfrNativeEventWriter.ensureSize(data, 8)) {
            JfrNativeEventWriter.putUncheckedLong(data, v);
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putString(JfrNativeEventWriterData data, String string) {
        JfrNativeEventWriter.putString(data, string, null);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putString(JfrNativeEventWriterData data, String string, UninterruptibleUtils.CharReplacer replacer) {
        if (string == null) {
            JfrNativeEventWriter.putByte(data, JfrChunkWriter.StringEncoding.NULL.getValue());
        } else if (string.isEmpty()) {
            JfrNativeEventWriter.putByte(data, JfrChunkWriter.StringEncoding.EMPTY_STRING.getValue());
        } else {
            int mUTF8Length = UninterruptibleUtils.String.modifiedUTF8Length(string, false, replacer);
            JfrNativeEventWriter.putByte(data, JfrChunkWriter.StringEncoding.UTF8_BYTE_ARRAY.getValue());
            JfrNativeEventWriter.putInt(data, mUTF8Length);
            if (JfrNativeEventWriter.ensureSize(data, mUTF8Length)) {
                Pointer newPosition = UninterruptibleUtils.String.toModifiedUTF8(string, data.getCurrentPos(), data.getEndPos(), false, replacer);
                data.setCurrentPos(newPosition);
            }
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putEventThread(JfrNativeEventWriterData data) {
        JfrNativeEventWriter.putThread(data, SubstrateJVM.getCurrentThreadId());
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putThread(JfrNativeEventWriterData data, Thread thread) {
        if (thread == null) {
            JfrNativeEventWriter.putThread(data, 0L);
        } else {
            JfrNativeEventWriter.putThread(data, SubstrateJVM.getThreadId(thread));
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putThread(JfrNativeEventWriterData data, long threadId) {
        JfrNativeEventWriter.putLong(data, threadId);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static void putClass(JfrNativeEventWriterData data, Class<?> aClass) {
        if (aClass == null) {
            JfrNativeEventWriter.putLong(data, 0L);
        } else {
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getClassId(aClass));
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static boolean ensureSize(JfrNativeEventWriterData data, int requested) {
        assert (requested > 0);
        if (!JfrNativeEventWriter.isValid(data)) {
            return false;
        }
        int totalRequested = requested + 1;
        if (JfrNativeEventWriter.getAvailableSize(data).belowThan(totalRequested) && !JfrNativeEventWriter.accommodate(data, JfrNativeEventWriter.getUncommittedSize(data), totalRequested)) {
            assert (!JfrNativeEventWriter.isValid(data));
            return false;
        }
        assert (JfrNativeEventWriter.getAvailableSize(data).aboveOrEqual(totalRequested));
        return true;
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void reserve(JfrNativeEventWriterData data, int size) {
        if (JfrNativeEventWriter.ensureSize(data, size)) {
            JfrNativeEventWriter.increaseCurrentPos(data, size);
        }
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void hardReset(JfrNativeEventWriterData data) {
        JfrBuffer buffer = data.getJfrBuffer();
        data.setStartPos(buffer.getCommittedPos());
        data.setCurrentPos(buffer.getCommittedPos());
        data.setEndPos(JfrBufferAccess.getDataEnd(buffer));
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void reset(JfrNativeEventWriterData data) {
        data.setCurrentPos(data.getStartPos());
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void cancel(JfrNativeEventWriterData data) {
        data.setEndPos((Pointer)WordFactory.nullPointer());
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static boolean accommodate(JfrNativeEventWriterData data, UnsignedWord uncommitted, int requested) {
        JfrBuffer newBuffer = JfrNativeEventWriter.accommodate0(data, uncommitted, requested);
        if (newBuffer.isNull()) {
            JfrNativeEventWriter.cancel(data);
            return false;
        }
        data.setJfrBuffer(newBuffer);
        JfrNativeEventWriter.hardReset(data);
        JfrNativeEventWriter.increaseCurrentPos(data, uncommitted);
        return true;
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static JfrBuffer accommodate0(JfrNativeEventWriterData data, UnsignedWord uncommitted, int requested) {
        JfrBuffer oldBuffer = data.getJfrBuffer();
        switch (oldBuffer.getBufferType()) {
            case THREAD_LOCAL_NATIVE: {
                return JfrThreadLocal.flushToGlobalMemory(oldBuffer, uncommitted, requested);
            }
            case C_HEAP: {
                return JfrNativeEventWriter.reuseOrReallocateBuffer(oldBuffer, uncommitted, requested);
            }
        }
        throw VMError.shouldNotReachHere("Unexpected type of buffer.");
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static JfrBuffer reuseOrReallocateBuffer(JfrBuffer oldBuffer, UnsignedWord uncommitted, int requested) {
        UnsignedWord unflushedSize = JfrBufferAccess.getUnflushedSize(oldBuffer);
        UnsignedWord totalUsedBytes = unflushedSize.add(uncommitted);
        UnsignedWord minNewSize = totalUsedBytes.add(requested);
        if (oldBuffer.getSize().belowThan(minNewSize)) {
            UnsignedWord newSize = oldBuffer.getSize();
            while (newSize.belowThan(minNewSize)) {
                newSize = newSize.multiply(2);
            }
            JfrBuffer result = JfrBufferAccess.allocate(newSize, oldBuffer.getBufferType());
            if (result.isNull()) {
                return (JfrBuffer)WordFactory.nullPointer();
            }
            UnmanagedMemoryUtil.copy(JfrBufferAccess.getFlushedPos(oldBuffer), result.getCommittedPos(), totalUsedBytes);
            JfrBufferAccess.increaseCommittedPos(result, unflushedSize);
            JfrBufferAccess.free(oldBuffer);
            assert (result.getSize().aboveThan(minNewSize));
            return result;
        }
        UnmanagedMemoryUtil.copy(JfrBufferAccess.getFlushedPos(oldBuffer), JfrBufferAccess.getDataStart(oldBuffer), totalUsedBytes);
        JfrBufferAccess.reinitialize(oldBuffer);
        JfrBufferAccess.increaseCommittedPos(oldBuffer, unflushedSize);
        return oldBuffer;
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static boolean commit(JfrNativeEventWriterData data) {
        if (!JfrNativeEventWriter.isValid(data)) {
            return false;
        }
        JfrNativeEventWriter.commitEvent(data);
        return true;
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void commitEvent(JfrNativeEventWriterData data) {
        assert (JfrNativeEventWriter.isValid(data));
        JfrBuffer buffer = data.getJfrBuffer();
        assert (buffer.getCommittedPos().equal((UnsignedWord)data.getStartPos()));
        assert (JfrBufferAccess.getDataEnd(data.getJfrBuffer()).equal((UnsignedWord)data.getEndPos()));
        Pointer newPosition = data.getCurrentPos();
        buffer.setCommittedPos(newPosition);
        data.setStartPos(newPosition);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static boolean isValid(JfrNativeEventWriterData data) {
        return data.getEndPos().isNonNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int makePaddedInt(int v) {
        assert (v <= 0x1FFFFFFF);
        long b1 = (v >>> 0 & 0x7F | 0x80) << 24;
        long b2 = (v >>> 7 & 0x7F | 0x80) << 16;
        long b3 = (v >>> 14 & 0x7F | 0x80) << 8;
        long b4 = (v >>> 21 & 0x7F) << 0;
        return (int)(b1 + b2 + b3 + b4);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void putPaddedInt(JfrNativeEventWriterData data, int v) {
        assert (v <= 0x1FFFFFFF);
        if (!JfrNativeEventWriter.ensureSize(data, 4)) {
            return;
        }
        long b = v & 0x7F;
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(b | 0x80L));
        b = v >>> 7 & 0x7F;
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(b | 0x80L));
        b = v >>> 14 & 0x7F;
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(b | 0x80L));
        b = v >>> 21 & 0x7F;
        JfrNativeEventWriter.putUncheckedByte(data, (byte)b);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void putUncheckedLong(JfrNativeEventWriterData data, long value) {
        long v = value;
        if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrNativeEventWriter.putUncheckedByte(data, (byte)v);
            return;
        }
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrNativeEventWriter.putUncheckedByte(data, (byte)v);
            return;
        }
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrNativeEventWriter.putUncheckedByte(data, (byte)v);
            return;
        }
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrNativeEventWriter.putUncheckedByte(data, (byte)v);
            return;
        }
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrNativeEventWriter.putUncheckedByte(data, (byte)v);
            return;
        }
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrNativeEventWriter.putUncheckedByte(data, (byte)v);
            return;
        }
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrNativeEventWriter.putUncheckedByte(data, (byte)v);
            return;
        }
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrNativeEventWriter.putUncheckedByte(data, (byte)v);
            return;
        }
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v | 0x80L));
        JfrNativeEventWriter.putUncheckedByte(data, (byte)(v >>> 7));
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void putUncheckedByte(JfrNativeEventWriterData data, byte i) {
        assert (JfrNativeEventWriter.getAvailableSize(data).aboveOrEqual(1));
        data.getCurrentPos().writeByte(0, i);
        JfrNativeEventWriter.increaseCurrentPos(data, 1);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static UnsignedWord getAvailableSize(JfrNativeEventWriterData data) {
        return data.getEndPos().subtract((UnsignedWord)data.getCurrentPos());
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static UnsignedWord getUncommittedSize(JfrNativeEventWriterData data) {
        return data.getCurrentPos().subtract((UnsignedWord)data.getStartPos());
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void increaseCurrentPos(JfrNativeEventWriterData data, int bytes) {
        data.setCurrentPos(data.getCurrentPos().add(bytes));
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void increaseCurrentPos(JfrNativeEventWriterData data, UnsignedWord bytes) {
        data.setCurrentPos(data.getCurrentPos().add(bytes));
    }
}

