/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class AnnotationTypeFeature
implements InternalFeature {
    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        AnalysisUniverse universe = accessImpl.getUniverse();
        universe.getTypes().stream().filter(AnalysisType::isAnnotation).filter(AnalysisType::isReachable).map(type -> universe.lookup((JavaType)type.getWrapped()).getArrayClass()).filter(annotationArray -> !annotationArray.isInstantiated()).forEach(annotationArray -> {
            accessImpl.registerAsInHeap((AnalysisType)annotationArray, (Object)"Is the array type of a reachable annotation.");
            access.requireAnalysisIteration();
        });
    }
}

