/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.ThreadSleepEventJDK17;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_ThreadGroup;
import com.oracle.svm.core.thread.Target_java_lang_ThreadLocal;
import com.oracle.svm.core.thread.Target_java_lang_ThreadLocal_ThreadLocalMap;
import com.oracle.svm.core.thread.Target_java_lang_Thread_Constants;
import com.oracle.svm.core.thread.Target_java_lang_Thread_FieldHolder;
import com.oracle.svm.core.thread.Target_jdk_internal_event_ThreadSleepEvent;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.util.ReflectionUtil;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.word.Pointer;

public final class JavaThreads {
    static final AtomicLong threadSeqNumber = new AtomicLong();
    static final AtomicInteger threadInitNumber = new AtomicInteger();

    private JavaThreads() {
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Thread fromTarget(Target_java_lang_Thread thread) {
        return (Thread)Thread.class.cast(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Target_java_lang_Thread toTarget(Thread thread) {
        return (Target_java_lang_Thread)Target_java_lang_Thread.class.cast(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getThreadId(Thread thread) {
        if (SubstrateUtil.HOSTED) {
            return (Long)ReflectionUtil.readField(Thread.class, (String)"tid", (Object)thread);
        }
        return JavaThreads.toTarget((Thread)thread).tid;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static ThreadGroup getRawThreadGroup(Thread thread) {
        Target_java_lang_Thread t = SubstrateUtil.cast(thread, Target_java_lang_Thread.class);
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            Target_java_lang_Thread_FieldHolder holder = t.holder;
            if (holder != null) {
                return holder.group;
            }
            return null;
        }
        return t.group;
    }

    public static boolean isInterrupted(Thread thread) {
        return JavaThreads.getInterruptedFlag(thread);
    }

    private static boolean getInterruptedFlag(Thread thread) {
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            return JavaThreads.toTarget((Thread)thread).interruptedJDK17OrLater;
        }
        return JavaThreads.toTarget((Thread)thread).interruptedJDK11OrEarlier;
    }

    static boolean getAndClearInterrupt(Thread thread) {
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtual(thread)) {
            return VirtualThreads.singleton().getAndClearInterrupt(thread);
        }
        return JavaThreads.getAndClearInterruptedFlag(thread);
    }

    static boolean getAndClearInterruptedFlag(Thread thread) {
        boolean oldValue = JavaThreads.isInterrupted(thread);
        if (oldValue) {
            JavaThreads.writeInterruptedFlag(thread, false);
        }
        return oldValue;
    }

    static void writeInterruptedFlag(Thread thread, boolean value) {
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            JavaThreads.toTarget((Thread)thread).interruptedJDK17OrLater = value;
        } else {
            JavaThreads.toTarget((Thread)thread).interruptedJDK11OrEarlier = value;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getParentThreadId(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).parentThreadId;
    }

    @Fold
    static boolean supportsVirtual() {
        return VirtualThreads.isSupported();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isVirtual(Thread thread) {
        return JavaThreads.supportsVirtual() && VirtualThreads.singleton().isVirtual(thread);
    }

    public static boolean isCurrentThreadVirtual() {
        if (!JavaThreads.supportsVirtual()) {
            return false;
        }
        Thread thread = PlatformThreads.currentThread.get();
        return thread != null && JavaThreads.toTarget((Thread)thread).vthread != null;
    }

    @AlwaysInline(value="Enable constant folding in case of Loom.")
    private static boolean isVirtualDisallowLoom(Thread thread) {
        if (LoomSupport.isEnabled()) {
            assert (!JavaThreads.isVirtual(thread)) : "should not see Loom virtual thread objects here";
            return false;
        }
        return JavaThreads.isVirtual(thread);
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Target_java_lang_ThreadGroup toTarget(ThreadGroup threadGroup) {
        return (Target_java_lang_ThreadGroup)Target_java_lang_ThreadGroup.class.cast(threadGroup);
    }

    static void join(Thread thread, long millis) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtual(thread)) {
            VirtualThreads.singleton().join(thread, millis);
        } else {
            PlatformThreads.join(thread, millis);
        }
    }

    static void yieldCurrent() {
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtualDisallowLoom(Thread.currentThread()) && !LoomSupport.isEnabled()) {
            VirtualThreads.singleton().yield();
        } else {
            PlatformThreads.singleton().yieldCurrent();
        }
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    public static StackTraceElement[] getStackTrace(boolean filterExceptions, Thread thread) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        if (JavaThreads.supportsVirtual()) {
            return VirtualThreads.singleton().getVirtualOrPlatformThreadStackTrace(filterExceptions, thread, callerSP);
        }
        return PlatformThreads.getStackTrace(filterExceptions, thread, callerSP);
    }

    public static void dispatchUncaughtException(Thread thread, Throwable throwable) {
        Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
        if (handler == null) {
            handler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (handler != null) {
            try {
                handler.uncaughtException(thread, throwable);
            }
            catch (Throwable throwable2) {}
        } else {
            System.err.print("Exception in thread \"" + Thread.currentThread().getName() + "\" ");
            throwable.printStackTrace();
        }
    }

    static void initializeNewThread(Target_java_lang_Thread tjlt, ThreadGroup groupArg, Runnable target, String name, long stackSize, AccessControlContext acc, boolean allowThreadLocals, boolean inheritThreadLocals) {
        boolean daemon;
        int priority;
        ThreadGroup group;
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        tjlt.name = name;
        Thread parent = Thread.currentThread();
        ThreadGroup threadGroup = group = groupArg != null ? groupArg : parent.getThreadGroup();
        if (JavaThreads.toTarget(parent) == tjlt) {
            priority = 5;
            daemon = false;
        } else {
            priority = parent.getPriority();
            daemon = parent.isDaemon();
        }
        JavaThreads.initThreadFields(tjlt, group, target, stackSize, priority, daemon);
        if (!VirtualThreads.isSupported() || !VirtualThreads.singleton().isVirtual(JavaThreads.fromTarget(tjlt))) {
            PlatformThreads.setThreadStatus(JavaThreads.fromTarget(tjlt), 0);
            if (JavaVersionUtil.JAVA_SPEC < 19) {
                JavaThreads.toTarget(group).addUnstarted();
            }
        }
        tjlt.inheritedAccessControlContext = acc != null ? acc : AccessController.getContext();
        JavaThreads.initNewThreadLocalsAndLoader(tjlt, allowThreadLocals, inheritThreadLocals, parent);
        tjlt.tid = Target_java_lang_Thread.nextThreadID();
    }

    static void initThreadFields(Target_java_lang_Thread tjlt, ThreadGroup group, Runnable target, long stackSize, int priority, boolean daemon) {
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            assert (tjlt.holder == null);
            tjlt.holder = new Target_java_lang_Thread_FieldHolder(group, target, stackSize, priority, daemon);
        } else {
            tjlt.group = group;
            tjlt.priority = priority;
            tjlt.daemon = daemon;
            tjlt.target = target;
            tjlt.setPriority(priority);
            tjlt.stackSize = stackSize;
        }
    }

    static void initNewThreadLocalsAndLoader(Target_java_lang_Thread tjlt, boolean allowThreadLocals, boolean inheritThreadLocals, Thread parent) {
        if (JavaVersionUtil.JAVA_SPEC >= 19 && !allowThreadLocals) {
            tjlt.threadLocals = Target_java_lang_ThreadLocal_ThreadLocalMap.NOT_SUPPORTED;
            tjlt.inheritableThreadLocals = Target_java_lang_ThreadLocal_ThreadLocalMap.NOT_SUPPORTED;
            tjlt.contextClassLoader = Target_java_lang_Thread_Constants.NOT_SUPPORTED_CLASSLOADER;
        } else if (inheritThreadLocals) {
            Target_java_lang_ThreadLocal_ThreadLocalMap parentMap = JavaThreads.toTarget((Thread)parent).inheritableThreadLocals;
            if (parentMap != null && (JavaVersionUtil.JAVA_SPEC < 19 || parentMap != Target_java_lang_ThreadLocal_ThreadLocalMap.NOT_SUPPORTED && parentMap.size() > 0)) {
                tjlt.inheritableThreadLocals = Target_java_lang_ThreadLocal.createInheritedMap(parentMap);
            }
            ClassLoader parentLoader = parent.getContextClassLoader();
            tjlt.contextClassLoader = JavaVersionUtil.JAVA_SPEC < 19 || parentLoader != Target_java_lang_Thread_Constants.NOT_SUPPORTED_CLASSLOADER ? parentLoader : ClassLoader.getSystemClassLoader();
        } else {
            tjlt.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
    }

    static void sleep(long millis) throws InterruptedException {
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            if (HasJfrSupport.get() && Target_jdk_internal_event_ThreadSleepEvent.isTurnedOn()) {
                Target_jdk_internal_event_ThreadSleepEvent event = new Target_jdk_internal_event_ThreadSleepEvent();
                try {
                    event.time = TimeUnit.MILLISECONDS.toNanos(millis);
                    event.begin();
                    JavaThreads.sleep0(millis);
                }
                finally {
                    event.commit();
                }
            } else {
                JavaThreads.sleep0(millis);
            }
        } else {
            long startTicks = JfrTicks.elapsedTicks();
            JavaThreads.sleep0(millis);
            ThreadSleepEventJDK17.emit(millis, startTicks);
        }
    }

    private static void sleep0(long millis) throws InterruptedException {
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtualDisallowLoom(Thread.currentThread()) && !LoomSupport.isEnabled()) {
            VirtualThreads.singleton().sleepMillis(millis);
        } else {
            PlatformThreads.sleep(millis);
        }
    }

    static boolean isAlive(Thread thread) {
        if (JavaThreads.supportsVirtual() && JavaThreads.isVirtualDisallowLoom(thread) && !LoomSupport.isEnabled()) {
            return VirtualThreads.singleton().isAlive(thread);
        }
        return PlatformThreads.isAlive(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setCurrentThreadLockHelper(Object helper) {
        if (JavaThreads.supportsVirtual()) {
            JavaThreads.toTarget((Thread)Thread.currentThread()).lockHelper = helper;
        } else {
            PlatformThreads.lockHelper.set(helper);
        }
    }

    @AlwaysInline(value="Locking fast path.")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Object getCurrentThreadLockHelper() {
        if (JavaThreads.supportsVirtual()) {
            return JavaThreads.toTarget((Thread)Thread.currentThread()).lockHelper;
        }
        return PlatformThreads.lockHelper.get();
    }

    public static void blockedOn(Target_sun_nio_ch_Interruptible b) {
        if (JavaThreads.supportsVirtual() && JavaThreads.isCurrentThreadVirtual()) {
            VirtualThreads.singleton().blockedOn(b);
        } else {
            PlatformThreads.blockedOn(b);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getCurrentThreadId() {
        long id = PlatformThreads.currentVThreadId.get();
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((id != 0L && id == JavaThreads.getThreadId(Thread.currentThread()) ? 1 : 0) != 0, (String)"ids must match");
        } else assert (id != 0L && id == JavaThreads.getThreadId(Thread.currentThread()));
        return id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getCurrentThreadIdOrZero() {
        if (CurrentIsolate.getCurrentThread().isNonNull()) {
            return PlatformThreads.currentVThreadId.get();
        }
        return 0L;
    }
}

